/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

public class VectorHashKeyWrapperBatch
extends VectorColumnSetInfo {
    private static final int MODEL_REFERENCES_COUNT = 7;
    private VectorExpression[] keyExpressions;
    private VectorHashKeyWrapper[] vectorHashKeyWrappers;
    private int keysFixedSize;

    public VectorHashKeyWrapperBatch(int keyCount) {
        super(keyCount);
    }

    public int getKeysFixedSize() {
        return this.keysFixedSize;
    }

    public VectorHashKeyWrapper[] getVectorHashKeyWrappers() {
        return this.vectorHashKeyWrappers;
    }

    public void evaluateBatch(VectorizedRowBatch batch) throws HiveException {
        LongColumnVector columnVector;
        int columnIndex;
        int keyIndex;
        int i;
        for (i = 0; i < this.keyExpressions.length; ++i) {
            this.keyExpressions[i].evaluate(batch);
        }
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (LongColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignLongNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignLongNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignLongNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignLongNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Long null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (DoubleColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingNoSelection(i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingSelection(i, batch.size, (DoubleColumnVector)columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignDoubleNoNullsRepeating(i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignDoubleNullsNoRepeatingNoSelection(i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignDoubleNullsRepeating(i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDoubleNullsNoRepeatingSelection(i, batch.size, (DoubleColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Double null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (BytesColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingNoSelection(i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingSelection(i, batch.size, (BytesColumnVector)columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignStringNoNullsRepeating(i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignStringNullsNoRepeatingNoSelection(i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignStringNullsRepeating(i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignStringNullsNoRepeatingSelection(i, batch.size, (BytesColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented String null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (DecimalColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingNoSelection(i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingSelection(i, batch.size, (DecimalColumnVector)columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignDecimalNoNullsRepeating(i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignDecimalNullsNoRepeatingNoSelection(i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignDecimalNullsRepeating(i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDecimalNullsNoRepeatingSelection(i, batch.size, (DecimalColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Decimal null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (TimestampColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingNoSelection(i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingSelection(i, batch.size, (TimestampColumnVector)columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignTimestampNoNullsRepeating(i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignTimestampNullsNoRepeatingNoSelection(i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignTimestampNullsRepeating(i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignTimestampNullsNoRepeatingSelection(i, batch.size, (TimestampColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented timestamp null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (IntervalDayTimeColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingNoSelection(i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingSelection(i, batch.size, (IntervalDayTimeColumnVector)columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignIntervalDayTimeNoNullsRepeating(i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignIntervalDayTimeNullsNoRepeatingNoSelection(i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignIntervalDayTimeNullsRepeating(i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignIntervalDayTimeNullsNoRepeatingSelection(i, batch.size, (IntervalDayTimeColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented intervalDayTime null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < batch.size; ++i) {
            this.vectorHashKeyWrappers[i].setHashKey();
        }
    }

    private void assignStringNullsNoRepeatingSelection(int index, int size, BytesColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignNullString(index);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[row], columnVector.start[row], columnVector.length[row]);
        }
    }

    private void assignStringNullsRepeating(int index, int size, BytesColumnVector columnVector) {
        if (columnVector.isNull[0]) {
            for (int i = 0; i < size; ++i) {
                this.vectorHashKeyWrappers[i].assignNullString(index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[0], columnVector.start[0], columnVector.length[0]);
            }
        }
    }

    private void assignStringNullsNoRepeatingNoSelection(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            if (columnVector.isNull[i]) {
                this.vectorHashKeyWrappers[i].assignNullString(index);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[i], columnVector.start[i], columnVector.length[i]);
        }
    }

    private void assignStringNoNullsRepeating(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[0], columnVector.start[0], columnVector.length[0]);
        }
    }

    private void assignStringNoNullsNoRepeatingSelection(int index, int size, BytesColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[row], columnVector.start[row], columnVector.length[row]);
        }
    }

    private void assignStringNoNullsNoRepeatingNoSelection(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[i], columnVector.start[i], columnVector.length[i]);
        }
    }

    private void assignDoubleNullsNoRepeatingSelection(int index, int size, DoubleColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignDouble(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullDouble(index);
        }
    }

    private void assignDoubleNullsRepeating(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullDouble(index);
        }
    }

    private void assignDoubleNullsNoRepeatingNoSelection(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullDouble(index);
        }
    }

    private void assignDoubleNoNullsRepeating(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[0]);
        }
    }

    private void assignDoubleNoNullsNoRepeatingSelection(int index, int size, DoubleColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignDoubleNoNullsNoRepeatingNoSelection(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[r]);
        }
    }

    private void assignLongNullsNoRepeatingSelection(int index, int size, LongColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignLong(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullLong(index);
        }
    }

    private void assignLongNullsRepeating(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullLong(index);
        }
    }

    private void assignLongNullsNoRepeatingNoSelection(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullLong(index);
        }
    }

    private void assignLongNoNullsRepeating(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[0]);
        }
    }

    private void assignLongNoNullsNoRepeatingSelection(int index, int size, LongColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignLongNoNullsNoRepeatingNoSelection(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[r]);
        }
    }

    private void assignDecimalNullsNoRepeatingSelection(int index, int size, DecimalColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignDecimal(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullDecimal(index);
        }
    }

    private void assignDecimalNullsRepeating(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullDecimal(index);
        }
    }

    private void assignDecimalNullsNoRepeatingNoSelection(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullDecimal(index);
        }
    }

    private void assignDecimalNoNullsRepeating(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[0]);
        }
    }

    private void assignDecimalNoNullsNoRepeatingSelection(int index, int size, DecimalColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignDecimalNoNullsNoRepeatingNoSelection(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[r]);
        }
    }

    private void assignTimestampNullsNoRepeatingSelection(int index, int size, TimestampColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignTimestamp(index, columnVector, row);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullTimestamp(index);
        }
    }

    private void assignTimestampNullsRepeating(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullTimestamp(index);
        }
    }

    private void assignTimestampNullsNoRepeatingNoSelection(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, r);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullTimestamp(index);
        }
    }

    private void assignTimestampNoNullsRepeating(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, 0);
        }
    }

    private void assignTimestampNoNullsNoRepeatingSelection(int index, int size, TimestampColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, selected[r]);
        }
    }

    private void assignTimestampNoNullsNoRepeatingNoSelection(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, r);
        }
    }

    private void assignIntervalDayTimeNullsNoRepeatingSelection(int index, int size, IntervalDayTimeColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignIntervalDayTime(index, columnVector, row);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullIntervalDayTime(index);
        }
    }

    private void assignIntervalDayTimeNullsRepeating(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(index);
        }
    }

    private void assignIntervalDayTimeNullsNoRepeatingNoSelection(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, r);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(index);
        }
    }

    private void assignIntervalDayTimeNoNullsRepeating(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, 0);
        }
    }

    private void assignIntervalDayTimeNoNullsNoRepeatingSelection(int index, int size, IntervalDayTimeColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, selected[r]);
        }
    }

    private void assignIntervalDayTimeNoNullsNoRepeatingNoSelection(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, r);
        }
    }

    public static VectorHashKeyWrapperBatch compileKeyWrapperBatch(VectorExpression[] keyExpressions) throws HiveException {
        int i;
        VectorHashKeyWrapperBatch compiledKeyWrapperBatch = new VectorHashKeyWrapperBatch(keyExpressions.length);
        compiledKeyWrapperBatch.keyExpressions = keyExpressions;
        compiledKeyWrapperBatch.keysFixedSize = 0;
        for (i = 0; i < keyExpressions.length; ++i) {
            compiledKeyWrapperBatch.addKey(keyExpressions[i].getOutputType());
        }
        compiledKeyWrapperBatch.finishAdding();
        compiledKeyWrapperBatch.vectorHashKeyWrappers = new VectorHashKeyWrapper[1024];
        for (i = 0; i < 1024; ++i) {
            compiledKeyWrapperBatch.vectorHashKeyWrappers[i] = compiledKeyWrapperBatch.allocateKeyWrapper();
        }
        JavaDataModel model = JavaDataModel.get();
        compiledKeyWrapperBatch.keysFixedSize += JavaDataModel.alignUp((int)(model.object() + model.ref() * 7 + model.primitive1()), (int)model.memoryAlign());
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForLongArrayOfSize(compiledKeyWrapperBatch.longIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForDoubleArrayOfSize(compiledKeyWrapperBatch.doubleIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.stringIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.decimalIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.timestampIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.intervalDayTimeIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForIntArrayOfSize(compiledKeyWrapperBatch.longIndices.length) * 2;
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForBooleanArrayOfSize(keyExpressions.length);
        return compiledKeyWrapperBatch;
    }

    public VectorHashKeyWrapper allocateKeyWrapper() {
        return new VectorHashKeyWrapper(this.longIndices.length, this.doubleIndices.length, this.stringIndices.length, this.decimalIndices.length, this.timestampIndices.length, this.intervalDayTimeIndices.length);
    }

    public Object getWritableKeyValue(VectorHashKeyWrapper kw, int i, VectorExpressionWriter keyOutputWriter) throws HiveException {
        VectorColumnSetInfo.KeyLookupHelper klh = this.indexLookup[i];
        if (klh.longIndex >= 0) {
            return kw.getIsLongNull(klh.longIndex) ? null : keyOutputWriter.writeValue(kw.getLongValue(klh.longIndex));
        }
        if (klh.doubleIndex >= 0) {
            return kw.getIsDoubleNull(klh.doubleIndex) ? null : keyOutputWriter.writeValue(kw.getDoubleValue(klh.doubleIndex));
        }
        if (klh.stringIndex >= 0) {
            return kw.getIsBytesNull(klh.stringIndex) ? null : keyOutputWriter.writeValue(kw.getBytes(klh.stringIndex), kw.getByteStart(klh.stringIndex), kw.getByteLength(klh.stringIndex));
        }
        if (klh.decimalIndex >= 0) {
            return kw.getIsDecimalNull(klh.decimalIndex) ? null : keyOutputWriter.writeValue(kw.getDecimal(klh.decimalIndex).getHiveDecimal());
        }
        if (klh.timestampIndex >= 0) {
            return kw.getIsTimestampNull(klh.timestampIndex) ? null : keyOutputWriter.writeValue(kw.getTimestamp(klh.timestampIndex));
        }
        if (klh.intervalDayTimeIndex >= 0) {
            return kw.getIsIntervalDayTimeNull(klh.intervalDayTimeIndex) ? null : keyOutputWriter.writeValue(kw.getIntervalDayTime(klh.intervalDayTimeIndex));
        }
        throw new HiveException(String.format("Internal inconsistent KeyLookupHelper at index [%d]:%d %d %d %d %d %d", i, klh.longIndex, klh.doubleIndex, klh.stringIndex, klh.decimalIndex, klh.timestampIndex, klh.intervalDayTimeIndex));
    }

    public int getVariableSize(int batchSize) {
        int variableSize = 0;
        if (0 < this.stringIndices.length) {
            for (int k = 0; k < batchSize; ++k) {
                VectorHashKeyWrapper hkw = this.vectorHashKeyWrappers[k];
                variableSize += hkw.getVariableSize();
            }
        }
        return variableSize;
    }
}

