/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hive.common.util.Murmur3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAffinitySplitLocationProvider
implements SplitLocationProvider {
    private final Logger LOG = LoggerFactory.getLogger(HostAffinitySplitLocationProvider.class);
    private final boolean isDebugEnabled = this.LOG.isDebugEnabled();
    private final String[] knownLocations;

    public HostAffinitySplitLocationProvider(String[] knownLocations) {
        Preconditions.checkState((knownLocations != null && knownLocations.length != 0 ? 1 : 0) != 0, (Object)(HostAffinitySplitLocationProvider.class.getName() + "needs at least 1 location to function"));
        this.knownLocations = knownLocations;
    }

    public String[] getLocations(InputSplit split) throws IOException {
        if (split instanceof FileSplit) {
            FileSplit fsplit = (FileSplit)split;
            long hash = this.generateHash(fsplit.getPath().toString(), fsplit.getStart());
            int indexRaw = (int)(hash % (long)this.knownLocations.length);
            int index = Math.abs(indexRaw);
            if (this.isDebugEnabled) {
                this.LOG.debug("Split at " + fsplit.getPath() + " with offset= " + fsplit.getStart() + ", length=" + fsplit.getLength() + " mapped to index=" + index + ", location=" + this.knownLocations[index]);
            }
            return new String[]{this.knownLocations[index]};
        }
        if (this.isDebugEnabled) {
            this.LOG.debug("Split: " + split + " is not a FileSplit. Using default locations");
        }
        return split.getLocations();
    }

    private long generateHash(String path, long startOffset) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        dob.writeLong(startOffset);
        dob.writeUTF(path);
        return Murmur3.hash64((byte[])dob.getData(), (int)0, (int)dob.getLength());
    }
}

