/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td.options;

import java.lang.reflect.Method;
import org.apache.connectors.td.options.DefaultOption;
import org.apache.connectors.td.options.SetupException;
import org.apache.hadoop.conf.Configuration;

public class NumberOption
extends DefaultOption {
    public NumberOption(String name, Integer defaultValue, boolean optional, Class configurationClass, String configMethod) {
        super(name, defaultValue.toString(), optional, configurationClass, configMethod);
    }

    @Override
    public boolean isValid(String value) {
        try {
            new Integer(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public void configure(Configuration confObj) throws SetupException {
        if (this.getValue() != null) {
            try {
                Method method = this.getConfigClass().getMethod(this.getConfigMethod(), this.getConfigClass());
                method.invoke(null, confObj, new Integer(this.getValue()));
            }
            catch (Exception e) {
                throw new SetupException("Config could not find method " + this.getConfigMethod() + " in " + this.getConfigClass().getCanonicalName(), e);
            }
        }
    }
}

