/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.widgets.callEndpointTabs;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.baserver.utils.CallEndpointMeta;
import org.pentaho.di.baserver.utils.inspector.Inspector;
import org.pentaho.di.baserver.utils.widgets.ButtonBuilder;
import org.pentaho.di.baserver.utils.widgets.CheckBoxBuilder;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.Tab;
import org.pentaho.di.baserver.utils.widgets.fields.Field;
import org.pentaho.di.baserver.utils.widgets.fields.TextVarFieldBuilder;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;

public class ServerTab
extends Tab {
    public static final int FIELD_WIDTH = 350;
    private final TextVar urlText;
    private final TextVar userNameText;
    private final TextVar passwordText;
    private final Button useSessionCB;
    private final TransMeta transMeta;

    public ServerTab(CTabFolder tabFolder, PropsUI props, TransMeta transMeta, ModifyListener modifyListener, SelectionListener selectionListener) {
        super(tabFolder, BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Title", (String[])new String[0]), props);
        this.transMeta = transMeta;
        Field urlField = (Field)((Object)new TextVarFieldBuilder(this, props).setVariableSpace((VariableSpace)transMeta).addModifyListener(modifyListener).setLabel(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.URL", (String[])new String[0])).setLeftPlacement(0).setWidth(350).build());
        this.urlText = (TextVar)urlField.getControl();
        Field userNameField = (Field)((Object)new TextVarFieldBuilder(this, props).setVariableSpace((VariableSpace)transMeta).addModifyListener(modifyListener).setLabel(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.UserName", (String[])new String[0])).setTop((Control)urlField).setTopMargin(10).setLeftPlacement(0).setWidth(350).build());
        this.userNameText = (TextVar)userNameField.getControl();
        Field passwordField = (Field)((Object)new TextVarFieldBuilder(this, props).setVariableSpace((VariableSpace)transMeta).addModifyListener(modifyListener).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.getSource();
                if (text.getText().startsWith("${")) {
                    text.setEchoChar('\u0000');
                } else {
                    text.setEchoChar('*');
                }
            }
        }).setLabel(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Password", (String[])new String[0])).setTop((Control)userNameField).setTopMargin(10).setLeftPlacement(0).setWidth(350).build());
        this.passwordText = (TextVar)passwordField.getControl();
        Button testConnectionButton = (Button)new ButtonBuilder(this, props).setLabelText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.TestConnection", (String[])new String[0])).setTop((Control)passwordField).setTopMargin(10).setLeftPlacement(0).build();
        testConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                ServerTab.this.testConnection(true);
            }
        });
        this.useSessionCB = (Button)new CheckBoxBuilder(this, props).setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.UseSession", (String[])new String[0])).addSelectionListener(selectionListener).setTop((Control)testConnectionButton).setTopMargin(10).setLeftPlacement(0).setRightPlacement(100).build();
    }

    public boolean testConnection(boolean showDialogOnSuccess) {
        String serverUrl = this.getServerUrl();
        String userName = this.getUserName();
        String password = this.getPassword();
        int serverStatus = Inspector.getInstance().checkServerStatus(serverUrl, userName, password);
        MessageBox messageBox = new MessageBox(this.getShell());
        switch (serverStatus) {
            case 200: {
                if (!showDialogOnSuccess) {
                    return true;
                }
                messageBox.setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Test.Success.Header", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Test.Success.Message", (String[])new String[0]));
                break;
            }
            case 401: {
                messageBox.setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Test.UnableLogin.Header", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Test.UnableLogin.Message", (String[])new String[0]));
                break;
            }
            default: {
                messageBox.setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Test.UnableConnect.Header", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Server.Test.UnableConnect.Message", (String[])new String[0]));
            }
        }
        messageBox.open();
        return serverStatus == 200;
    }

    @Override
    public void loadData(CallEndpointMeta meta) {
        this.urlText.setText(meta.getServerURL());
        this.userNameText.setText(meta.getUserName());
        this.passwordText.setText(meta.getPassword());
        boolean bypassingAuthentication = meta.isBypassingAuthentication();
        this.useSessionCB.setSelection(bypassingAuthentication);
    }

    @Override
    public void saveData(CallEndpointMeta meta) {
        meta.setServerURL(this.urlText.getText());
        meta.setUserName(this.userNameText.getText());
        meta.setPassword(this.passwordText.getText());
        meta.setBypassingAuthentication(this.useSessionCB.getSelection());
    }

    public String getServerUrl() {
        return this.transMeta.environmentSubstitute(this.urlText.getText());
    }

    public String getUserName() {
        return this.transMeta.environmentSubstitute(this.userNameText.getText());
    }

    public String getPassword() {
        return this.transMeta.environmentSubstitute(this.passwordText.getText());
    }
}

