/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.baserver.utils.widgets.ButtonBuilder;
import org.pentaho.di.baserver.utils.widgets.ImageBuilder;
import org.pentaho.di.baserver.utils.widgets.SeparatorBuilder;
import org.pentaho.di.baserver.utils.widgets.fields.Field;
import org.pentaho.di.baserver.utils.widgets.fields.TextBoxFieldBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public abstract class BAServerCommonDialog<T extends BaseStepMeta>
extends BaseStepDialog
implements StepDialogInterface {
    public static final int LEFT_PLACEMENT = 0;
    public static final int RIGHT_PLACEMENT = 100;
    public static final int LARGE_MARGIN = 15;
    public static final int MEDIUM_MARGIN = 10;
    public static final int SMALL_MARGIN = 5;
    public static final int FIELD_WIDTH = 350;
    public static final int BOTTOM_BUTTON_WIDTH = 80;
    protected static Class<?> PKG = BAServerCommonDialog.class;
    protected final ModifyListener changeListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            BAServerCommonDialog.this.processInputChange();
        }
    };
    protected final SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            super.widgetSelected(selectionEvent);
            BAServerCommonDialog.this.processInputChange();
        }
    };
    private Text stepName;
    private T metaInfo;
    private Button wOK;

    public BAServerCommonDialog(Shell parent, T baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, baseStepMeta, transMeta, stepname);
        this.metaInfo = baseStepMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.shell.setText(BaseMessages.getString(PKG, (String)this.getTitleKey(), (String[])new String[0]));
        this.changed = this.metaInfo.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        formLayout.marginWidth = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setMinimumSize(this.getMinimumWidth(), this.getMinimumHeight());
        this.shell.setSize(this.getMinimumWidth(), this.getMinimumHeight());
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.metaInfo);
        Control top = this.buildStepNameInput((Composite)this.shell);
        Composite container = new Composite((Composite)this.shell, 0);
        container.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)container);
        this.buildContent(container);
        Composite buttons = this.createButtons();
        Label bottomSeparator = (Label)new SeparatorBuilder((Composite)this.shell, this.props).setLeftPlacement(0).setRightPlacement(100).build();
        ((FormData)bottomSeparator.getLayoutData()).bottom = new FormAttachment((Control)buttons, -15);
        FormData containerLD = new FormData();
        containerLD.top = new FormAttachment(top, 15);
        containerLD.bottom = new FormAttachment((Control)bottomSeparator, -15);
        containerLD.left = new FormAttachment(0);
        containerLD.right = new FormAttachment(100);
        container.setLayoutData((Object)containerLD);
        this.stepName.addModifyListener(this.changeListener);
        ShellAdapter lsShell = new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BAServerCommonDialog.this.cancel();
            }
        };
        this.shell.addShellListener((ShellListener)lsShell);
        this.loadData(this.metaInfo);
        this.metaInfo.setChanged(this.changed);
        this.stepName.selectAll();
        this.stepName.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private Composite createButtons() {
        Composite container = new Composite((Composite)this.shell, 0);
        container.setLayout((Layout)new FormLayout());
        FormData layoutData = new FormData();
        layoutData.bottom = new FormAttachment(100);
        layoutData.left = new FormAttachment(0);
        layoutData.right = new FormAttachment(100);
        container.setLayoutData((Object)layoutData);
        this.props.setLook((Control)container);
        Button wCancel = (Button)new ButtonBuilder(container, this.props).setLabelText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0])).setRightPlacement(100).build();
        wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                BAServerCommonDialog.this.cancel();
            }
        });
        this.wOK = (Button)new ButtonBuilder(container, this.props).setLabelText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0])).setWidth(80).build();
        ((FormData)this.wOK.getLayoutData()).right = new FormAttachment((Control)wCancel, -4, 16384);
        ((FormData)wCancel.getLayoutData()).width = 80;
        this.wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                BAServerCommonDialog.this.ok();
            }
        });
        return container;
    }

    public T getMetaInfo() {
        return this.metaInfo;
    }

    protected String[] getFieldNames() {
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (stepMeta != null) {
            try {
                RowMetaInterface row = this.transMeta.getPrevStepFields(stepMeta);
                ArrayList<String> entries = new ArrayList<String>();
                for (int i = 0; i < row.size(); ++i) {
                    entries.add(row.getValueMeta(i).getName());
                }
                String[] fieldNames = entries.toArray(new String[entries.size()]);
                Const.sortStrings((String[])fieldNames);
                return fieldNames;
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
        }
        return new String[0];
    }

    protected void loadData(T metaInfo) {
        this.stepName.setText(this.stepname);
    }

    protected void saveData(T meta) {
        this.stepname = this.stepName.getText();
    }

    private void processInputChange() {
        this.metaInfo.setChanged();
        this.wOK.setEnabled(this.isValid());
    }

    protected boolean isValid() {
        return !Const.isEmpty((String)this.stepName.getText());
    }

    private void ok() {
        this.saveData(this.metaInfo);
        this.dispose();
    }

    private void cancel() {
        this.stepname = null;
        this.metaInfo.setChanged(this.changed);
        this.dispose();
    }

    private Control buildStepNameInput(Composite parent) {
        Field field = (Field)((Object)new TextBoxFieldBuilder(parent, this.props).setLabel(BaseMessages.getString(PKG, (String)"BAServerUtils.Dialog.StepName", (String[])new String[0])).setLeftPlacement(0).setWidth(350).build());
        this.stepName = (Text)field.getControl();
        this.stepName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BAServerCommonDialog.this.processInputChange();
            }
        });
        Label icon = (Label)new ImageBuilder(parent, this.props).setImage(this.getImage()).setRightPlacement(100).build();
        ((FormData)icon.getLayoutData()).top = new FormAttachment((Control)field, 0, 0x1000000);
        return new SeparatorBuilder(parent, this.props).setTop((Control)field).setTopMargin(15).setLeftPlacement(0).setRightPlacement(100).build();
    }

    protected int getMinimumHeight() {
        return 500;
    }

    protected int getMinimumWidth() {
        return 600;
    }

    protected abstract String getTitleKey();

    protected abstract void buildContent(Composite var1);

    protected abstract Image getImage();
}

