/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.karaf.commands.CXFController;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="cxf", name="start-endpoint", description="Starts a CXF Endpoint on a Bus.")
public class StartEndpointCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="bus", description="The CXF bus name where to look for the Endpoint", required=true, multiValued=false)
    String busName;
    @Argument(index=1, name="endpoint", description="The Endpoint name to start", required=true, multiValued=false)
    String endpoint;
    private CXFController cxfController;

    public void setController(CXFController controller) {
        this.cxfController = controller;
    }

    protected Object doExecute() throws Exception {
        Bus b = this.cxfController.getBus(this.busName);
        ServerRegistry reg = (ServerRegistry)b.getExtension(ServerRegistry.class);
        List servers = reg.getServers();
        for (Server serv : servers) {
            if (!this.endpoint.equals(serv.getEndpoint().getEndpointInfo().getName().getLocalPart())) continue;
            serv.start();
        }
        return null;
    }
}

