/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AbstractTransport;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.protocol.impl.URLTransport;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;

public abstract class AbstractJMSTransport
extends AbstractTransport
implements TransportLayer {
    private static final HapiLog log = HapiLogFactory.getHapiLog(URLTransport.class);
    public static final String CLIENT_ID_KEY = "CLIENT_ID";
    public static final String CONNECTION_METADATA_KEY = "CONNECTION_METADATA";
    public static final String DESTINATION_NAME_KEY = "DESTINATION_NAME";
    private Map myMetadata = this.makeMetadata();

    private Map makeMetadata() {
        HashMap<String, String> md = new HashMap<String, String>();
        try {
            md.put(CLIENT_ID_KEY, this.getConnection().getClientID());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", e);
        }
        try {
            md.put(CONNECTION_METADATA_KEY, (String)this.getConnection().getMetaData());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", e);
        }
        try {
            md.put(DESTINATION_NAME_KEY, this.getDestinationName());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", e);
        }
        return md;
    }

    protected abstract String getDestinationName() throws JMSException;

    public abstract Connection getConnection();

    protected abstract Message getMessage() throws JMSException;

    protected abstract void sendJMS(Message var1) throws JMSException;

    protected abstract Message receiveJMS() throws JMSException;

    private static String getName(Destination theDestination) throws JMSException {
        String name = null;
        if (theDestination instanceof Queue) {
            name = ((Queue)theDestination).getQueueName();
        } else if (theDestination instanceof Topic) {
            name = ((Topic)theDestination).getTopicName();
        } else {
            throw new IllegalArgumentException("We don't support Destinations of type " + theDestination.getClass().getName());
        }
        return name;
    }

    public void doSend(Transportable theMessage) throws TransportException {
        try {
            Message message = this.toMessage(theMessage);
            this.sendJMS(message);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }

    protected Message toMessage(Transportable theSource) throws TransportException {
        Message message;
        try {
            message = this.getMessage();
            if (!(message instanceof TextMessage)) {
                throw new TransportException("This implementation expects getMessage() to return  a TextMessage.  Override this method if another message type is to be used");
            }
            ((TextMessage)message).setText(theSource.getMessage());
            for (Object key : theSource.getMetadata().keySet()) {
                Object val = theSource.getMetadata().get(key);
                message.setObjectProperty(key.toString(), val);
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return message;
    }

    protected Transportable toTransportable(Message theMessage) throws TransportException {
        if (!(theMessage instanceof TextMessage)) {
            throw new TransportException("This implementation expects getMessage() to return  a TextMessage.  Override this method if another message type is to be used");
        }
        TransportableImpl result = null;
        try {
            String text = ((TextMessage)theMessage).getText();
            result = new TransportableImpl(text);
            result.getMetadata().putAll(this.getCommonMetadata());
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return result;
    }

    public Transportable doReceive() throws TransportException {
        Transportable result = null;
        try {
            Message message = this.receiveJMS();
            result = this.toTransportable(message);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return result;
    }

    public Map getCommonMetadata() {
        return this.myMetadata;
    }
}

