/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.vfs.ui;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.vfs.messages.Messages;

public class ComboBoxInputDialog {
    String title;
    String text;
    String enteredText;
    int width;
    int height;
    Shell dialog;
    boolean okPressed = false;
    Combo rootInput = null;
    String[] roots = null;

    public ComboBoxInputDialog(String title, String text, String[] roots, int width, int height) {
        this.title = title;
        this.text = text;
        this.width = width;
        this.height = height;
        this.roots = roots;
        this.init();
    }

    public String open() {
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        String returnValue = this.text;
        returnValue = this.okPressed ? this.enteredText : null;
        this.dialog.dispose();
        return returnValue;
    }

    public void init() {
        this.dialog = ComboBoxInputDialog.createModalDialogShell(this.width, this.height, this.title);
        this.dialog.setLayout((Layout)new GridLayout(4, false));
        Composite content = new Composite((Composite)this.dialog, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 4;
        content.setLayoutData((Object)gridData);
        content.setLayout((Layout)new GridLayout(1, false));
        this.rootInput = new Combo(content, 2052);
        this.rootInput.setItems(this.roots);
        gridData = new GridData(4, 4, true, true);
        this.rootInput.setLayoutData((Object)gridData);
        Label left = new Label((Composite)this.dialog, 0);
        gridData = new GridData(4, 4, true, false);
        left.setLayoutData((Object)gridData);
        final Button ok = new Button((Composite)this.dialog, 8);
        gridData = new GridData(131072, 4, false, false);
        ok.setLayoutData((Object)gridData);
        ok.setText(Messages.getString("ComboBoxInputDialog.ok"));
        Button cancel = new Button((Composite)this.dialog, 8);
        gridData = new GridData(131072, 4, false, false);
        cancel.setLayoutData((Object)gridData);
        cancel.setText(Messages.getString("ComboBoxInputDialog.cancel"));
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComboBoxInputDialog.this.okPressed = e.getSource() == ok;
                ComboBoxInputDialog.this.enteredText = ComboBoxInputDialog.this.rootInput.getText();
                ComboBoxInputDialog.this.dialog.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        ok.addSelectionListener(listener);
        this.rootInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ComboBoxInputDialog.this.okPressed = true;
                    ComboBoxInputDialog.this.enteredText = ComboBoxInputDialog.this.rootInput.getText();
                    ComboBoxInputDialog.this.dialog.close();
                } else {
                    ComboBoxInputDialog.this.okPressed = false;
                }
            }
        });
        cancel.addSelectionListener(listener);
    }

    public static void centerShellOnDisplay(Shell shell, Display display, int desiredWidth, int desiredHeight) {
        int screenWidth = display.getPrimaryMonitor().getBounds().width;
        int screenHeight = display.getPrimaryMonitor().getBounds().height;
        int applicationX = Math.abs(screenWidth - desiredWidth) / 2;
        int applicationY = Math.abs(screenHeight - desiredHeight) / 2;
        shell.setSize(desiredWidth, desiredHeight);
        shell.setLocation(applicationX, applicationY);
    }

    public static Shell createModalDialogShell(int desiredWidth, int desiredHeight, String title) {
        Shell shell = new Shell(Display.getCurrent(), 67680);
        shell.setText(title);
        ComboBoxInputDialog.centerShellOnDisplay(shell, Display.getCurrent(), desiredWidth, desiredHeight);
        return shell;
    }
}

