/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractConditions;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.db.Clustering;

public final class ColumnConditions
extends AbstractConditions {
    private final List<ColumnCondition> columnConditions;
    private final List<ColumnCondition> staticConditions;

    private ColumnConditions(Builder builder) {
        this.columnConditions = builder.columnConditions;
        this.staticConditions = builder.staticConditions;
    }

    @Override
    public boolean appliesToStaticColumns() {
        return !this.staticConditions.isEmpty();
    }

    @Override
    public boolean appliesToRegularColumns() {
        return !this.columnConditions.isEmpty();
    }

    public Collection<ColumnDefinition> getColumns() {
        return Stream.concat(this.columnConditions.stream(), this.staticConditions.stream()).map(e -> e.column).collect(Collectors.toList());
    }

    @Override
    public boolean isEmpty() {
        return this.columnConditions.isEmpty() && this.staticConditions.isEmpty();
    }

    @Override
    public void addConditionsTo(CQL3CasRequest request, Clustering clustering, QueryOptions options) {
        if (!this.columnConditions.isEmpty()) {
            request.addConditions(clustering, this.columnConditions, options);
        }
        if (!this.staticConditions.isEmpty()) {
            request.addConditions(Clustering.STATIC_CLUSTERING, this.staticConditions, options);
        }
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        this.columnConditions.forEach(p -> p.addFunctionsTo(functions));
        this.staticConditions.forEach(p -> p.addFunctionsTo(functions));
    }

    public Collection<ColumnCondition> columnConditions() {
        return this.columnConditions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ColumnCondition> columnConditions = Collections.emptyList();
        private List<ColumnCondition> staticConditions = Collections.emptyList();

        public Builder add(ColumnCondition condition) {
            List<ColumnCondition> conds = null;
            if (condition.column.isStatic()) {
                if (this.staticConditions.isEmpty()) {
                    this.staticConditions = new ArrayList<ColumnCondition>();
                }
                conds = this.staticConditions;
            } else {
                if (this.columnConditions.isEmpty()) {
                    this.columnConditions = new ArrayList<ColumnCondition>();
                }
                conds = this.columnConditions;
            }
            conds.add(condition);
            return this;
        }

        public ColumnConditions build() {
            return new ColumnConditions(this);
        }

        private Builder() {
        }
    }
}

