/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.SoapHelper;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.uifoundation.chart.ChartHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.request.HttpWebServiceRequestHandler;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.xml.sax.EntityResolver;

public class HttpWebService
extends ServletBase {
    private static final long serialVersionUID = -2011812808062152707L;
    private static final Log logger = LogFactory.getLog(HttpWebService.class);

    @Override
    public Log getLogger() {
        return logger;
    }

    public String getPayloadAsString(HttpServletRequest request) throws IOException {
        BufferedReader reader = request.getReader();
        if (reader != null) {
            return IOUtils.toString((Reader)reader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetFixMe(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block17: {
            try {
                String actionPath = request.getParameter("path");
                String solutionName = actionPath.substring(0, actionPath.indexOf(47, 1));
                String actionName = actionPath.substring(actionPath.lastIndexOf(47));
                String actionSeqPath = ActionInfo.buildSolutionPath((String)solutionName, (String)actionPath, (String)actionName);
                String component = request.getParameter("component");
                String content = this.getPayloadAsString(request);
                HttpRequestParameterProvider parameterProvider = null;
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (content != null && content.length() > 0) {
                    Document doc = XmlDom4JHelper.getDocFromString((String)content, (EntityResolver)new PentahoEntityResolver());
                    List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
                    for (int i = 0; i < parameterNodes.size(); ++i) {
                        Node parameterNode = (Node)parameterNodes.get(i);
                        String parameterName = parameterNode.getName();
                        String parameterValue = parameterNode.getText();
                        if ("action".equals(parameterName)) {
                            ActionInfo info = ActionInfo.parseActionString((String)parameterValue);
                            solutionName = info.getSolutionName();
                            actionPath = info.getPath();
                            actionName = info.getActionName();
                            continue;
                        }
                        if ("component".equals(parameterName)) {
                            component = parameterValue;
                            continue;
                        }
                        parameters.put(parameterName, parameterValue);
                    }
                    parameterProvider = new SimpleParameterProvider(parameters);
                } else {
                    parameterProvider = new HttpRequestParameterProvider(request);
                }
                response.setContentType("text/xml");
                response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
                IPentahoSession userSession = this.getPentahoSession(request);
                String instanceId = request.getParameter("instance-id");
                String processId = ((Object)((Object)this)).getClass().getName();
                ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
                SimpleOutputHandler outputHandler = new SimpleOutputHandler((OutputStream)contentStream, false);
                ServletOutputStream outputStream = response.getOutputStream();
                if (component == null || "action".equals(component)) {
                    HttpWebServiceRequestHandler requestHandler = new HttpWebServiceRequestHandler(userSession, null, (IOutputHandler)outputHandler, (IParameterProvider)parameterProvider, null);
                    requestHandler.setParameterProvider("session", (IParameterProvider)new HttpSessionParameterProvider(userSession));
                    requestHandler.setInstanceId(instanceId);
                    requestHandler.setProcessId(processId);
                    requestHandler.setActionPath(actionSeqPath);
                    this.debug(Messages.getInstance().getString("HttpWebService.DEBUG_WEB_SERVICE_START"));
                    IRuntimeContext runtime = null;
                    try {
                        runtime = requestHandler.handleActionRequest(0, 0);
                        Document responseDoc = SoapHelper.createSoapResponseDocument((IRuntimeContext)runtime, (IOutputHandler)outputHandler, (OutputStream)contentStream, (List)requestHandler.getMessages());
                        XmlDom4JHelper.saveDom((Document)responseDoc, (OutputStream)outputStream, (String)PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8"), (boolean)true);
                        break block17;
                    }
                    finally {
                        if (runtime != null) {
                            runtime.dispose();
                        }
                    }
                }
                if ("dial".equals(component)) {
                    this.doDial(solutionName, actionPath, actionName, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession);
                } else if ("chart".equals(component)) {
                    this.doChart(actionPath, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession);
                } else if ("xaction-parameter".equals(component)) {
                    this.doParameter(solutionName, actionPath, actionName, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession, response);
                }
            }
            catch (Throwable t) {
                this.error(Messages.getInstance().getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE"), t);
            }
        }
        this.debug(Messages.getInstance().getString("HttpWebService.DEBUG_WEB_SERVICE_END"));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void doParameter(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, HttpServletResponse response) throws IOException {
        IActionSequence actionSequence = new ActionSequenceJCRHelper().getActionSequence(ActionInfo.buildSolutionPath((String)solutionName, (String)actionPath, (String)actionName), PentahoSystem.loggingLevel, RepositoryFilePermission.READ);
        if (actionSequence == null) {
            logger.debug((Object)Messages.getInstance().getString("HttpWebService.ERROR_0002_NOTFOUND", new Object[]{solutionName, actionPath, actionName}));
            response.sendError(500);
            return;
        }
        Document document = DocumentHelper.createDocument();
        try {
            Element parametersElement = document.addElement("parameters");
            Map params = actionSequence.getInputDefinitionsForParameterProvider("request");
            for (Map.Entry entry : params.entrySet()) {
                String paramName = (String)entry.getKey();
                IActionParameter paramDef = (IActionParameter)entry.getValue();
                String value = paramDef.getStringValue();
                Class type = "list".equalsIgnoreCase(paramDef.getType()) ? String[].class : String.class;
                String label = paramDef.getSelectionDisplayName();
                String[] values = StringUtils.isEmpty((String)value) ? new String[]{} : new String[]{value};
                this.createParameterElement(parametersElement, paramName, type, label, "user", "parameters", values);
            }
            this.createParameterElement(parametersElement, "solution", String.class, null, "system", "system", new String[]{solutionName});
            this.createParameterElement(parametersElement, "path", String.class, null, "system", "system", new String[]{actionPath});
            this.createParameterElement(parametersElement, "action", String.class, null, "system", "system", new String[]{actionName});
            this.createParameterElement(parametersElement, "prompt", String.class, null, "system", "system", new String[]{"yes", "no"});
            this.createParameterElement(parametersElement, "instance-id", String.class, null, "system", "system", new String[]{parameterProvider.getStringParameter("instance-id", null)});
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getInstance().getString("HttpWebService.ERROR_0003_UNEXPECTED"), (Throwable)e);
            response.sendError(500);
            return;
        }
        XMLWriter writer = new XMLWriter(outputStream, OutputFormat.createPrettyPrint());
        writer.write(document);
        writer.flush();
    }

    private Element createParameterElement(Element parametersElement, String paramName, Class type, String label, String role, String group, String[] values) {
        Element parameterElement = parametersElement.addElement("parameter");
        parameterElement.addAttribute("name", paramName);
        parameterElement.addAttribute("type", type.getName());
        if (!StringUtils.isEmpty((String)label)) {
            Element labelAttr = parameterElement.addElement("attribute");
            labelAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
            labelAttr.addAttribute("name", "label");
            labelAttr.addAttribute("value", label);
        }
        Element roleAttr = parameterElement.addElement("attribute");
        roleAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        roleAttr.addAttribute("name", "role");
        roleAttr.addAttribute("value", role);
        Element paramGroupAttr = parameterElement.addElement("attribute");
        paramGroupAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        paramGroupAttr.addAttribute("name", "parameter-group");
        paramGroupAttr.addAttribute("value", group);
        Element paramGroupLabelAttr = parameterElement.addElement("attribute");
        paramGroupLabelAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        paramGroupLabelAttr.addAttribute("name", "parameter-group-label");
        paramGroupLabelAttr.addAttribute("value", this.lookupParameterGroupLabel(group));
        if (values.length > 0) {
            Element valuesElement = parameterElement.addElement("values");
            for (String value : values) {
                Element valueAttr = valuesElement.addElement("value");
                valueAttr.addAttribute("type", String.class.getName());
                valueAttr.addAttribute("value", value);
                valueAttr.addAttribute("selected", String.valueOf(values.length == 1));
            }
        }
        return parameterElement;
    }

    private String lookupParameterGroupLabel(String group) {
        if ("system".equals(group)) {
            return Messages.getInstance().getString("HttpWebService.PARAMETER_GROUP_SYSTEM");
        }
        return Messages.getInstance().getString("HttpWebService.PARAMETER_GROUP_USER");
    }

    protected void doDial(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        StringBuffer buffer = new StringBuffer();
        ArrayList messages = new ArrayList();
        boolean ok = ChartHelper.doDial((String)solutionName, (String)actionPath, (String)actionName, (IParameterProvider)parameterProvider, (StringBuffer)buffer, (IPentahoSession)userSession, messages, (ILogger)this);
        if (!ok) {
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", Messages.getInstance().getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), messages, buffer);
        }
        try {
            XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((String)buffer.toString()), (OutputStream)outputStream, (String)PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8"), (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void doChart(String actionPath, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        String chartTypeStr = parameterProvider.getStringParameter("chart-type", "");
        if ("PieChart".equals(chartTypeStr)) {
            this.doPieChart(actionPath, parameterProvider, outputStream, userSession);
        } else {
            this.doOtherChart(actionPath, parameterProvider, outputStream, userSession);
        }
    }

    protected void doPieChart(String actionPath, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        StringBuffer buffer = new StringBuffer();
        ArrayList messages = new ArrayList();
        boolean ok = ChartHelper.doPieChart((String)actionPath, (IParameterProvider)parameterProvider, (StringBuffer)buffer, (IPentahoSession)userSession, messages, (ILogger)this);
        if (!ok) {
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", Messages.getInstance().getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), messages, buffer);
        }
        try {
            XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((String)buffer.toString()), (OutputStream)outputStream, (String)PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8"), (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void doOtherChart(String actionPath, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        StringBuffer buffer = new StringBuffer();
        ArrayList messages = new ArrayList();
        boolean ok = ChartHelper.doChart((String)actionPath, (IParameterProvider)parameterProvider, (StringBuffer)buffer, (IPentahoSession)userSession, messages, (ILogger)this);
        if (!ok) {
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", Messages.getInstance().getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), messages, buffer);
        }
        try {
            XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((String)buffer.toString()), (OutputStream)outputStream, (String)PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8"), (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            if (!this.isSecurityDetailsRequest(request)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getInstance().getString("HttpWebService.DEBUG_MISSING_ACTION_PARAMETER"));
                }
                this.doGetFixMe(request, response);
                return;
            }
            String responseEncoding = PentahoSystem.getSystemSetting((String)"web-service-encoding", (String)"utf-8");
            response.setContentType("text/xml");
            response.setCharacterEncoding(responseEncoding);
            String details = this.getDetailsParameter(request);
            if ("users".equalsIgnoreCase(details)) {
                Document usersDoc = this.getUsers();
                Document aclsDoc = this.getACLs();
                XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((Document[])new Document[]{usersDoc, aclsDoc}), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
            } else if ("roles".equalsIgnoreCase(details)) {
                Document rolesDoc = this.getRoles();
                Document aclsDoc = this.getACLs();
                XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((Document[])new Document[]{rolesDoc, aclsDoc}), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
            } else if ("acls".equalsIgnoreCase(details)) {
                Document aclsDoc = this.getACLs();
                XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((Document)aclsDoc), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
            } else {
                if (!"all".equalsIgnoreCase(details) && logger.isWarnEnabled()) {
                    logger.warn((Object)Messages.getInstance().getString("HttpWebService.WARN_MISSING_DETAILS_PARAMETER"));
                }
                Document usersDoc = this.getUsers();
                Document rolesDoc = this.getRoles();
                Document aclsDoc = this.getACLs();
                XmlDom4JHelper.saveDom((Document)SoapHelper.createSoapResponseDocument((Document[])new Document[]{usersDoc, rolesDoc, aclsDoc}), (OutputStream)response.getOutputStream(), (String)responseEncoding, (boolean)true);
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected boolean isSecurityDetailsRequest(HttpServletRequest request) {
        return this.hasActionInQueryString(request) || this.hasActionInBody(request);
    }

    protected String getDetailsParameter(HttpServletRequest request) {
        Map parameters;
        Object obj;
        String payload;
        String details = request.getParameter("details");
        if (null != details) {
            return details;
        }
        try {
            payload = this.getPayloadAsString(request);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)e);
            }
            return null;
        }
        if (null != payload && payload.length() > 0 && null != (obj = (parameters = this.getParameterMapFromPayload(payload)).get("details"))) {
            return obj.toString();
        }
        return null;
    }

    protected boolean hasActionInBody(HttpServletRequest request) {
        Map parameters;
        Object obj;
        String payload;
        try {
            payload = this.getPayloadAsString(request);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)e);
            }
            return false;
        }
        return null != payload && payload.length() > 0 && null != (obj = (parameters = this.getParameterMapFromPayload(payload)).get("action")) && obj.toString().equalsIgnoreCase("securitydetails");
    }

    protected boolean hasActionInQueryString(HttpServletRequest request) {
        String action = request.getParameter("action");
        return "securitydetails".equalsIgnoreCase(action);
    }

    protected Map getParameterMapFromPayload(String xml) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Document doc = null;
        try {
            doc = XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            this.error(Messages.getInstance().getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE"), e);
            return parameters;
        }
        List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
        for (int i = 0; i < parameterNodes.size(); ++i) {
            Node parameterNode = (Node)parameterNodes.get(i);
            String parameterName = parameterNode.getName();
            String parameterValue = parameterNode.getText();
            parameters.put(parameterName, parameterValue);
        }
        return parameters;
    }

    protected Document getUsers() throws ServletException, IOException {
        IUserRoleListService service = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        DefaultElement rootElement = new DefaultElement("users");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (service != null) {
            List users = service.getAllUsers();
            Iterator usersIterator = users.iterator();
            while (usersIterator.hasNext()) {
                String username = usersIterator.next().toString();
                if (null == username || username.length() <= 0) continue;
                rootElement.addElement("user").addCDATA(username);
            }
        }
        return doc;
    }

    protected Document getRoles() throws ServletException, IOException {
        IUserRoleListService service = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        DefaultElement rootElement = new DefaultElement("roles");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (service != null) {
            List roles = service.getAllRoles();
            Iterator rolesIterator = roles.iterator();
            while (rolesIterator.hasNext()) {
                String roleName = rolesIterator.next().toString();
                if (null == roleName || roleName.length() <= 0) continue;
                rootElement.addElement("role").addCDATA(roleName);
            }
        }
        return doc;
    }

    protected Document getACLs() throws ServletException, IOException {
        HashMap validPermissionsNameMap = new HashMap();
        DefaultElement rootElement = new DefaultElement("acls");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (validPermissionsNameMap != null) {
            Set aclsKeySet = validPermissionsNameMap.keySet();
            Iterator aclsIterator = aclsKeySet.iterator();
            while (aclsIterator.hasNext()) {
                String aclMask;
                String aclName = aclsIterator.next().toString();
                String string = aclMask = null != validPermissionsNameMap.get(aclName) ? validPermissionsNameMap.get(aclName).toString() : null;
                if (null == aclName || aclName.length() <= 0 || null == aclMask || aclMask.length() <= 0) continue;
                Element aclElement = rootElement.addElement("acl");
                aclElement.addElement("name").addCDATA(aclName);
                aclElement.addElement("mask").setText(aclMask);
            }
        }
        return doc;
    }
}

