/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.pentaho.platform.api.util.IWadlDocumentResource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DefaultSpringWadlResourceDocument
implements IWadlDocumentResource {
    ClassPathResource springResource;
    String pluginId = "";
    boolean isPlugin = false;
    private static String WADL_NAME = "META-INF/wadl/wadlExtension.xml";

    public DefaultSpringWadlResourceDocument(Resource resource) {
        this.springResource = (ClassPathResource)resource;
        if (this.springResource.getClassLoader() instanceof PluginClassLoader) {
            this.isPlugin = true;
            this.pluginId = ((PluginClassLoader)this.springResource.getClassLoader()).getPluginDir().getName();
        }
    }

    public InputStream getResourceAsStream() throws IOException {
        Enumeration<URL> urls = this.springResource.getClassLoader().getResources(WADL_NAME);
        InputStream is = null;
        URL url = null;
        String systemPath = this.getSystemPath();
        while (urls.hasMoreElements()) {
            String urlString;
            url = urls.nextElement();
            if (this.isPlugin && !(urlString = url.getPath()).contains(systemPath + "/" + this.pluginId)) continue;
            break;
        }
        if (url != null) {
            try {
                is = this.getInputStream(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return is;
    }

    protected String getSystemPath() {
        return PentahoSystem.getApplicationContext().getSolutionPath("system");
    }

    protected InputStream getInputStream(URL url) throws IOException {
        return url.openConnection().getInputStream();
    }

    public boolean isFromPlugin() {
        return this.isPlugin;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

