/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.api.resources.RoleListWrapper;
import org.pentaho.platform.web.http.api.resources.UserListWrapper;
import org.pentaho.platform.web.http.api.resources.services.SystemService;

public class UserRoleListService {
    protected IUserRoleListService userRoleListService;
    private ArrayList<String> extraRoles;
    private ArrayList<String> systemRoles;
    private Comparator<String> roleComparator;
    private Comparator<String> userComparator;

    public List<String> doGetRolesForUser(String user) throws UnauthorizedException {
        if (this.canAdminister()) {
            return this.getRolesForUser(user);
        }
        throw new UnauthorizedException();
    }

    public List<String> doGetUsersInRole(String role) throws UnauthorizedException {
        if (this.canAdminister()) {
            return this.getUsersInRole(role);
        }
        throw new UnauthorizedException();
    }

    public UserListWrapper getUsers() {
        IUserRoleListService service = this.getUserRoleListService();
        List allUsers = service.getAllUsers();
        if (null != this.userComparator) {
            Collections.sort(allUsers, this.userComparator);
        }
        return new UserListWrapper(allUsers);
    }

    public RoleListWrapper getRoles() {
        return this.getRoles(true);
    }

    public RoleListWrapper getRoles(boolean includeExtraRoles) {
        List roles = this.getUserRoleListService().getAllRoles();
        if (!includeExtraRoles) {
            for (String role : this.getExtraRoles()) {
                roles.remove(role);
            }
        }
        return new RoleListWrapper(roles);
    }

    public RoleListWrapper getAllRoles() {
        HashSet<String> existingRoles = new HashSet<String>(this.getUserRoleListService().getAllRoles());
        ArrayList<String> extraRoles = this.getExtraRoles();
        if (extraRoles == null) {
            extraRoles = new ArrayList();
        }
        if (this.systemRoles != null) {
            extraRoles.addAll(this.systemRoles);
        }
        existingRoles.addAll(extraRoles);
        return new RoleListWrapper(existingRoles);
    }

    public RoleListWrapper getSystemRoles() {
        return new RoleListWrapper((Collection<String>)this.systemRoles);
    }

    public RoleListWrapper getPermissionRoles(String adminRole) {
        IUserRoleListService userRoleListService = this.getUserRoleListService();
        List allRoles = userRoleListService.getAllRoles();
        if (allRoles.contains(adminRole)) {
            allRoles.remove(adminRole);
        }
        if (this.extraRoles != null) {
            for (String extraRole : this.extraRoles) {
                if (allRoles.contains(extraRole)) continue;
                allRoles.add(extraRole);
            }
        }
        if (null != this.roleComparator) {
            Collections.sort(allRoles, this.roleComparator);
        }
        return new RoleListWrapper(allRoles);
    }

    public RoleListWrapper getExtraRolesList() {
        return new RoleListWrapper((Collection<String>)this.getExtraRoles());
    }

    protected boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }

    public IUserRoleListService getUserRoleListService() {
        if (this.userRoleListService == null) {
            this.userRoleListService = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        }
        return this.userRoleListService;
    }

    protected List<String> getRolesForUser(String user) {
        return SystemService.getSystemService().getRolesForUser(user);
    }

    protected List<String> getUsersInRole(String role) {
        return SystemService.getSystemService().getUsersInRole(role);
    }

    public void setExtraRoles(ArrayList<String> extraRoles) {
        this.extraRoles = extraRoles;
    }

    public void setSystemRoles(ArrayList<String> systemRoles) {
        this.systemRoles = systemRoles;
    }

    public void setRoleComparator(Comparator<String> roleComparator) {
        this.roleComparator = roleComparator;
    }

    public void setUserComparator(Comparator<String> userComparator) {
        this.userComparator = userComparator;
    }

    public ArrayList<String> getExtraRoles() {
        return this.extraRoles;
    }

    public class UnauthorizedException
    extends Exception {
    }
}

