/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.platform.util.versionchecker.PentahoVersionCheckReflectHelper;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;

@Path(value="/version")
@Facet(name="Unsupported")
public class VersionResource
extends AbstractJaxRSResource {
    protected static final Log logger = LogFactory.getLog(VersionResource.class);

    @GET
    @Path(value="/show")
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response getVersion() {
        VersionInfo versionInfo = VersionHelper.getVersionInfo(PentahoSystem.class);
        return Response.ok((Object)versionInfo.getVersionNumber()).type("text/plain").build();
    }

    @GET
    @Path(value="/softwareUpdates")
    @Facet(name="Unsupported")
    @Produces(value={"text/plain"})
    public String getSoftwareUpdatesDocument() {
        if (PentahoVersionCheckReflectHelper.isVersionCheckerAvailable()) {
            List results = PentahoVersionCheckReflectHelper.performVersionCheck((boolean)false, (int)-1);
            return PentahoVersionCheckReflectHelper.logVersionCheck((List)results, (Log)logger);
        }
        return "<vercheck><error><[!CDATA[Version Checker is disabled]]></error></vercheck>";
    }
}

