/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.GlobalListsPublisher;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.SettingsPublisher;
import org.pentaho.platform.engine.services.metadata.MetadataPublisher;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.olap.IOlapService;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.utils.SystemUtils;

@Path(value="/system/refresh")
@Facet(name="Unsupported")
public class SystemRefreshResource
extends AbstractJaxRSResource {
    @GET
    @Path(value="/globalActions")
    @Facet(name="Unsupported")
    @Produces(value={"text/plain"})
    public Response executeGlobalActions() {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        if (this.canAdminister()) {
            PentahoSystem.publish((IPentahoSession)pentahoSession, (String)GlobalListsPublisher.class.getName());
        }
        return Response.ok().type("text/plain").build();
    }

    @GET
    @Path(value="/metadata")
    @Facet(name="Unsupported")
    @Produces(value={"text/plain"})
    public String refreshMetadata() {
        String result = null;
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        if (this.canAdminister()) {
            result = PentahoSystem.publish((IPentahoSession)pentahoSession, (String)MetadataPublisher.class.getName());
        }
        return result;
    }

    @GET
    @Path(value="/systemSettings")
    @Facet(name="Unsupported")
    @Produces(value={"text/plain"})
    public Response refreshSystemSettings() {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        if (this.canAdminister()) {
            PentahoSystem.publish((IPentahoSession)pentahoSession, (String)SettingsPublisher.class.getName());
        }
        return Response.ok().type("text/plain").build();
    }

    @GET
    @Path(value="/mondrianSchemaCache")
    @Produces(value={"text/plain", "application/json"})
    @Facet(name="Unsupported")
    public Response flushMondrianSchemaCache() {
        if (this.canAdminister()) {
            IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
            if (this.canAdminister()) {
                IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)pentahoSession);
                mondrianCatalogService.reInit(pentahoSession);
                IOlapService olapService = (IOlapService)PentahoSystem.get(IOlapService.class, (String)"IOlapService", (IPentahoSession)pentahoSession);
                olapService.flushAll(pentahoSession);
            }
            return Response.ok().type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/mondrianSingleSchemaCache")
    @Produces(value={"text/plain", "application/json"})
    @Facet(name="Unsupported")
    public Response flushMondrianSchemaCache(@QueryParam(value="name") String name) {
        if (this.canAdminister()) {
            IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
            if (this.canAdminister()) {
                IOlapService olapService = (IOlapService)PentahoSystem.get(IOlapService.class, (String)"IOlapService", (IPentahoSession)pentahoSession);
                olapService.flush(pentahoSession, name);
            }
            return Response.ok().type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @Deprecated
    @GET
    @Path(value="/reportingDataCache")
    @Produces(value={"text/plain", "application/json"})
    @Facet(name="Unsupported")
    public Response purgeReportingDataCache() {
        if (this.canAdminister()) {
            ICacheManager cacheManager = (ICacheManager)PentahoSystem.get(ICacheManager.class);
            cacheManager.clearRegionCache("report-dataset-cache");
            cacheManager.clearRegionCache("report-output-handlers");
            Runnable clearCacheAction = (Runnable)PentahoSystem.get(Runnable.class, (String)"_ClearCacheAction", (IPentahoSession)PentahoSessionHolder.getSession());
            if (clearCacheAction != null) {
                clearCacheAction.run();
            }
            return Response.ok().type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private boolean canAdminister() {
        return SystemUtils.canAdminister();
    }
}

