/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.IRepositoryImportLogger;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.pentaho.platform.web.http.api.resources.utils.SystemUtils;

@Path(value="/repo/files/import")
public class RepositoryImportResource {
    private static final Logger LOGGER = Logger.getLogger(RepositoryImportResource.class);
    private static final String DEFAULT_CHAR_SET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Facet(name="Unsupported")
    public Response doPostImport(@FormDataParam(value="importDir") String importDir, @FormDataParam(value="fileUpload") InputStream fileUpload, @FormDataParam(value="overwriteFile") String overwriteFile, @FormDataParam(value="overwriteAclPermissions") String overwriteAclPermissions, @FormDataParam(value="applyAclPermissions") String applyAclPermission, @FormDataParam(value="retainOwnership") String retainOwnership, @FormDataParam(value="charSet") String charSet, @FormDataParam(value="logLevel") String logLevel, @FormDataParam(value="fileUpload") FormDataContentDisposition fileInfo, @FormDataParam(value="fileNameOverride") String fileNameOverride) {
        String responseBody;
        IRepositoryImportLogger importLogger = null;
        ByteArrayOutputStream importLoggerStream = new ByteArrayOutputStream();
        boolean logJobStarted = false;
        if (StringUtils.isBlank((String)charSet)) {
            charSet = DEFAULT_CHAR_SET;
        }
        try {
            String mimeType;
            FileService fileService;
            boolean retainOwnershipFlag;
            this.validateImportAccess(importDir);
            boolean overwriteFileFlag = !"false".equals(overwriteFile);
            boolean overwriteAclSettingsFlag = "true".equals(overwriteAclPermissions);
            boolean applyAclSettingsFlag = "true".equals(applyAclPermission);
            boolean bl = retainOwnershipFlag = "true".equals(retainOwnership);
            if (logLevel == null || logLevel.length() <= 0) {
                logLevel = "ERROR";
            }
            if (!(fileService = new FileService()).doCanAdminister()) {
                applyAclSettingsFlag = false;
                retainOwnershipFlag = true;
            }
            Level level = Level.toLevel((String)logLevel);
            ImportSession.getSession().setAclProperties(applyAclSettingsFlag, retainOwnershipFlag, overwriteAclSettingsFlag);
            String fileName = fileNameOverride != null ? fileNameOverride : fileInfo.getFileName();
            RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder();
            bundleBuilder.input(fileUpload);
            bundleBuilder.charSet(charSet);
            bundleBuilder.path(importDir);
            bundleBuilder.overwriteFile(overwriteFileFlag);
            bundleBuilder.applyAclSettings(applyAclSettingsFlag);
            bundleBuilder.overwriteAclSettings(overwriteAclSettingsFlag);
            bundleBuilder.retainOwnership(retainOwnershipFlag);
            bundleBuilder.name(fileName);
            RepositoryFileImportBundle bundle = bundleBuilder.build();
            IPlatformMimeResolver mimeResolver = (IPlatformMimeResolver)PentahoSystem.get(IPlatformMimeResolver.class);
            String mimeTypeFromFile = mimeResolver.resolveMimeForFileName(fileName);
            if (mimeTypeFromFile == null) {
                Response response = Response.ok((Object)"INVALID_MIME_TYPE", (String)"text/html").build();
                return response;
            }
            bundleBuilder.mime(mimeTypeFromFile);
            IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
            importLogger = importer.getRepositoryImportLogger();
            String string = mimeType = bundle.getMimeType() != null ? bundle.getMimeType() : mimeResolver.resolveMimeForBundle((IPlatformImportBundle)bundle);
            if (mimeType == null) {
                Response response = Response.ok((Object)"INVALID_MIME_TYPE", (String)"text/html").build();
                return response;
            }
            logJobStarted = true;
            importLogger.startJob(importLoggerStream, importDir, level);
            importer.importFile(bundle);
            IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)PentahoSessionHolder.getSession());
            mondrianCatalogService.reInit(PentahoSessionHolder.getSession());
        }
        catch (PentahoAccessControlException e) {
            Response overwriteAclSettingsFlag = Response.serverError().entity((Object)e.toString()).build();
            return overwriteAclSettingsFlag;
        }
        catch (Exception e) {
            Response overwriteAclSettingsFlag = Response.serverError().entity((Object)e.toString()).build();
            return overwriteAclSettingsFlag;
        }
        finally {
            ImportSession.clearSession();
            if (logJobStarted) {
                importLogger.endJob();
            }
        }
        try {
            responseBody = importLoggerStream.toString(charSet);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("Encoding of response body is failed. (charSet=" + charSet + ")"), (Throwable)e);
            responseBody = importLoggerStream.toString();
        }
        return Response.ok((Object)responseBody, (String)"text/html").build();
    }

    protected void validateImportAccess(String importDir) throws PentahoAccessControlException {
        boolean canUpload = SystemUtils.canUpload(importDir);
        if (!canUpload) {
            throw new PentahoAccessControlException("User is not authorized to perform this operation");
        }
    }
}

