/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.PasswordHelper;

@Path(value="/password")
public class PasswordResource {
    private static final String FORM_HTML = "<html><body><form method='post'><input type=\"password\" name=\"password\"/><input type=\"submit\" value=\"Submit\"/></form><br/>%s</body></html>";

    @POST
    @Path(value="/encrypt")
    @Produces(value={"text/html"})
    @Facet(name="Unsupported")
    public Response encryptPassword(@FormParam(value="password") String password) {
        if (this.isAllowed()) {
            String encPwd = "";
            if (password != null) {
                encPwd = this.getPasswordHelper().encrypt(password);
            }
            return Response.ok((Object)String.format(FORM_HTML, encPwd)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/encrypt")
    @Produces(value={"text/html"})
    @Facet(name="Unsupported")
    public Response encryptionForm() {
        if (this.isAllowed()) {
            return Response.ok((Object)String.format(FORM_HTML, "")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    PasswordHelper getPasswordHelper() {
        return new PasswordHelper();
    }

    private boolean isAllowed() {
        return this.getAuthorizationPolicy().isAllowed("org.pentaho.security.administerSecurity");
    }

    IAuthorizationPolicy getAuthorizationPolicy() {
        return (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
    }
}

