/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;
import org.springframework.util.Assert;

public class ExtraRolesUserRoleListServiceDecorator
implements IUserRoleListService {
    private static final Log logger = LogFactory.getLog(ExtraRolesUserRoleListServiceDecorator.class);
    private IUserRoleListService userRoleListService;
    private List<String> extraRoles;

    public List<String> getAllRoles() {
        return this.userRoleListService.getAllRoles();
    }

    protected List<String> getNewRoles() {
        List origRoles = this.userRoleListService.getAllRoles();
        ArrayList<String> newRoles1 = new ArrayList<String>(origRoles);
        for (String extraRole : this.extraRoles) {
            if (origRoles.contains(extraRole)) continue;
            newRoles1.add(extraRole);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("original roles: %s, new roles: %s", origRoles, newRoles1));
        }
        return newRoles1;
    }

    public List<String> getAllUsers() {
        return this.userRoleListService.getAllUsers();
    }

    public void setUserRoleListService(IUserRoleListService userRoleListService) {
        this.userRoleListService = userRoleListService;
    }

    public void setExtraRoles(List<String> extraRoles) {
        Assert.notNull(extraRoles);
        this.extraRoles = new ArrayList<String>(extraRoles);
    }

    public void setSystemRoles(Set<String> systemRoles) {
        Assert.notNull(systemRoles);
    }

    public List<String> getAllRoles(ITenant tenant) {
        return this.userRoleListService.getAllRoles(tenant);
    }

    public List<String> getAllUsers(ITenant tenant) {
        return this.userRoleListService.getAllUsers();
    }

    public List<String> getUsersInRole(ITenant tenant, String role) {
        return this.userRoleListService.getUsersInRole(tenant, role);
    }

    public List<String> getRolesForUser(ITenant tenant, String username) {
        return this.userRoleListService.getRolesForUser(tenant, username);
    }

    public List<String> getSystemRoles() {
        return this.userRoleListService.getSystemRoles();
    }
}

