/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.springframework.util.Assert;

class PentahoMetadataInformationMap {
    private static final Log log = LogFactory.getLog(PentahoMetadataInformationMap.class);
    private Map<String, Map<String, RepositoryFile>> mapping = new HashMap<String, Map<String, RepositoryFile>>();
    private static final String DOMAIN_ID_KEY = "domain-id";

    PentahoMetadataInformationMap() {
    }

    public Collection<String> getDomainIds() {
        return this.mapping.keySet();
    }

    public void reset() {
        this.mapping.clear();
    }

    public RepositoryFile getDomainFile(String domainId) {
        Assert.notNull((Object)domainId);
        Map<String, RepositoryFile> details = this.getDetails(domainId, false);
        if (details != null) {
            return details.get(DOMAIN_ID_KEY);
        }
        return null;
    }

    public Set<RepositoryFile> getFiles(String domainId) {
        HashSet<RepositoryFile> files = new HashSet<RepositoryFile>();
        Map<String, RepositoryFile> details = this.mapping.get(domainId);
        if (null != details) {
            files.addAll(details.values());
        }
        return files;
    }

    public void addDomain(String domainId, RepositoryFile child) {
        Map<String, RepositoryFile> details = this.getDetails(domainId, true);
        if (details.get(DOMAIN_ID_KEY) != null) {
            log.warn((Object)"Adding domain when one already exists");
        }
        details.put(DOMAIN_ID_KEY, child);
    }

    public void addLocale(String domainId, String locale, RepositoryFile child) {
        Map<String, RepositoryFile> details = this.getDetails(domainId, true);
        if (details.get(locale) != null) {
            log.warn((Object)"Adding locale when one already exists");
        }
        details.put(locale, child);
    }

    public RepositoryFile getLocaleFile(String domainId, String locale) {
        RepositoryFile file = null;
        Map<String, RepositoryFile> details = this.getDetails(domainId, false);
        if (details != null) {
            file = details.get(locale);
        }
        return file;
    }

    public Map<String, RepositoryFile> getLocaleFiles(String domainId) {
        HashMap<String, RepositoryFile> files = null;
        Map<String, RepositoryFile> details = this.getDetails(domainId, false);
        if (details != null) {
            files = new HashMap<String, RepositoryFile>(details.size());
            files.putAll(details);
            files.remove(DOMAIN_ID_KEY);
        }
        return files;
    }

    public void deleteDomain(String domainId) {
        this.mapping.remove(domainId);
    }

    private Map<String, RepositoryFile> getDetails(String domainId, boolean create) {
        Map<String, RepositoryFile> details = this.mapping.get(domainId);
        if (details == null && create) {
            details = new HashMap<String, RepositoryFile>();
            this.mapping.put(domainId, details);
        }
        return details;
    }
}

