/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.email;

import java.io.Serializable;
import java.util.Properties;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.email.IEmailConfiguration;

@XmlRootElement
public class EmailConfiguration
implements Serializable,
IEmailConfiguration {
    private static final long serialVersionUID = -7765357320116118032L;
    private boolean authenticate;
    private boolean debug;
    private String defaultFrom;
    private String fromName;
    private String smtpHost;
    private Integer smtpPort;
    private String smtpProtocol;
    private boolean smtpQuitWait;
    private String userId;
    private String password;
    private boolean useSsl;
    private boolean useStartTls;

    public EmailConfiguration() {
    }

    public EmailConfiguration(boolean authenticate, boolean debug, String defaultFrom, String fromName, String smtpHost, Integer smtpPort, String smtpProtocol, boolean smtpQuitWait, String userId, String password, boolean useSsl, boolean useStartTls) {
        this.authenticate = authenticate;
        this.debug = debug;
        this.defaultFrom = defaultFrom;
        this.fromName = fromName;
        this.smtpHost = smtpHost;
        this.smtpPort = smtpPort;
        this.smtpProtocol = smtpProtocol;
        this.smtpQuitWait = smtpQuitWait;
        this.userId = userId;
        this.password = password;
        this.useSsl = useSsl;
        this.useStartTls = useStartTls;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDefaultFrom() {
        return this.defaultFrom == null ? "" : this.defaultFrom;
    }

    public void setDefaultFrom(String defaultFrom) {
        this.defaultFrom = defaultFrom;
    }

    public String getFromName() {
        return this.fromName == null ? "" : this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getSmtpHost() {
        return this.smtpHost == null ? "" : this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public Integer getSmtpPort() {
        return this.smtpPort == null ? Integer.MIN_VALUE : this.smtpPort;
    }

    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpProtocol() {
        return this.smtpProtocol == null ? "" : this.smtpProtocol;
    }

    public void setSmtpProtocol(String smtpProtocol) {
        this.smtpProtocol = smtpProtocol;
    }

    public String getUserId() {
        return this.userId == null ? "" : this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isUseStartTls() {
        return this.useStartTls;
    }

    public void setUseStartTls(boolean useStartTls) {
        this.useStartTls = useStartTls;
    }

    public boolean isSmtpQuitWait() {
        return this.smtpQuitWait;
    }

    public void setSmtpQuitWait(boolean smtpQuitWait) {
        this.smtpQuitWait = smtpQuitWait;
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        properties.setProperty("mail.transport.protocol", this.getSmtpProtocol());
        properties.setProperty("mail.smtp.host", this.getSmtpHost());
        properties.setProperty("mail.smtp.port", this.getSmtpPort().toString());
        properties.setProperty("mail.smtp.host", this.getSmtpHost());
        properties.setProperty("mail.smtp.host", this.getSmtpHost());
        properties.setProperty("mail.smtp.host", this.getSmtpHost());
        properties.setProperty("mail.smtp.host", this.getSmtpHost());
        return properties;
    }

    public String toString() {
        return "authenticate='" + this.authenticate + '\'' + ", debug='" + this.debug + '\'' + ", defaultFrom='" + this.defaultFrom + '\'' + ", fromName='" + this.fromName + '\'' + ", smtpHost='" + this.smtpHost + '\'' + ", smtpPort=" + this.smtpPort + ", smtpProtocol='" + this.smtpProtocol + '\'' + ", smtpQuitWait=" + this.smtpQuitWait + ", userId='" + this.userId + '\'' + ", password='" + this.password + '\'' + ", useSsl=" + this.useSsl + ", useStartTls=" + this.useStartTls;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EmailConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EmailConfiguration that = (EmailConfiguration)obj;
        return this.authenticate == that.authenticate && this.debug == that.debug && this.smtpQuitWait == that.smtpQuitWait && this.useSsl == that.useSsl && this.useStartTls == that.useStartTls && ObjectUtils.equals((Object)this.getSmtpPort(), (Object)that.getSmtpPort()) && this.isEquals(this.defaultFrom, that.defaultFrom) && this.isEquals(this.fromName, that.fromName) && this.isEquals(this.smtpHost, that.smtpHost) && this.isEquals(this.smtpProtocol, that.smtpProtocol) && this.isEquals(this.userId, that.userId) && this.isEquals(this.password, that.password);
    }

    private boolean isEquals(String a, String b) {
        return StringUtils.equals((String)a, (String)b) || StringUtils.isBlank((String)a) && StringUtils.isBlank((String)b);
    }
}

