/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.util.List;
import ofc4j.model.elements.Element;
import ofc4j.model.elements.PieChart;
import org.dom4j.Node;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;

public class PieChartFactory
extends AbstractChartFactory {
    private static final String START_ANGLE_NODE_LOC = "start-angle";
    private static final String ANIMATE_NODE_LOC = "animate";
    private boolean animate;
    private Integer startAngle;

    @Override
    protected void createElements() {
        this.elements.add(this.getPieChartFromColumn(0));
    }

    public Element getPieChartFromColumn(int col) {
        PieChart pc = new PieChart();
        PieChart.Slice[] slices = new PieChart.Slice[this.getRowCount()];
        for (int row = 0; row < this.getRowCount(); ++row) {
            double d = ((Number)this.getValueAt(row, col)).doubleValue();
            String label = (String)this.chart.getXAxis().getLabels().getLabels().get(row);
            slices[row] = new PieChart.Slice((Number)d, label, label);
            if (this.tooltipText == null) continue;
            slices[row].setTooltip(this.tooltipText);
        }
        pc.addSlices(slices);
        pc.setColours((List)this.colors);
        pc.setStartAngle(this.startAngle);
        pc.setAnimate(this.animate);
        if (this.alpha != null) {
            pc.setAlpha(this.alpha);
        }
        return pc;
    }

    @Override
    protected void setupStyles() {
        super.setupStyles();
        Node temp = this.chartNode.selectSingleNode(ANIMATE_NODE_LOC);
        if (PieChartFactory.getValue(temp) != null) {
            this.animate = "true".equals(PieChartFactory.getValue(temp));
        }
        if (PieChartFactory.getValue(temp = this.chartNode.selectSingleNode(START_ANGLE_NODE_LOC)) != null) {
            this.startAngle = Integer.parseInt(PieChartFactory.getValue(temp));
        }
    }
}

