/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSettingsConfiguration
implements IConfiguration {
    private String id;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ISystemSettings settings;

    public SystemSettingsConfiguration(String id, ISystemSettings settings) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("SystemSettings is null");
        }
        this.id = id;
        this.settings = settings;
    }

    public String getId() {
        return "system";
    }

    public Properties getProperties() throws IOException {
        Properties props = new Properties();
        List elements = this.settings.getSystemSettings("pentaho-system");
        if (elements == null) {
            return null;
        }
        elements = ((Element)elements.get(0)).content();
        this.addElementsToProperties(elements, props, "");
        return props;
    }

    private void addElementsToProperties(List elements, Properties props, String parentPath) {
        for (Object o : elements) {
            Node ele = (Node)o;
            if (ele.getNodeType() != 1) continue;
            String contents = ele.getText().trim();
            String newParentPath = "";
            if (!StringUtils.isEmpty((String)parentPath)) {
                newParentPath = parentPath + ".";
            }
            newParentPath = newParentPath + ele.getName();
            if (!StringUtils.isEmpty((String)contents)) {
                props.setProperty(newParentPath, contents);
            }
            if (!(ele instanceof Element)) continue;
            List children = ((Element)ele).content();
            this.addElementsToProperties(children, props, newParentPath);
        }
    }

    public void update(Properties properties) throws IOException {
        throw new UnsupportedOperationException("SystemSettings does not support write-back");
    }
}

