/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SftpClient {
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;

    public void close() throws IOException;

    public Handle open(String var1, EnumSet<OpenMode> var2) throws IOException;

    public void close(Handle var1) throws IOException;

    public void remove(String var1) throws IOException;

    public void rename(String var1, String var2) throws IOException;

    public int read(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public void write(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public void mkdir(String var1) throws IOException;

    public void rmdir(String var1) throws IOException;

    public Handle openDir(String var1) throws IOException;

    public DirEntry[] readDir(Handle var1) throws IOException;

    public String canonicalPath(String var1) throws IOException;

    public Attributes stat(String var1) throws IOException;

    public Attributes lstat(String var1) throws IOException;

    public Attributes stat(Handle var1) throws IOException;

    public void setStat(String var1, Attributes var2) throws IOException;

    public void setStat(Handle var1, Attributes var2) throws IOException;

    public String readLink(String var1) throws IOException;

    public void symLink(String var1, String var2) throws IOException;

    public Iterable<DirEntry> readDir(String var1) throws IOException;

    public InputStream read(String var1) throws IOException;

    public OutputStream write(String var1) throws IOException;

    public static class DirEntry {
        public String filename;
        public String longFilename;
        public Attributes attributes;

        public DirEntry(String filename, String longFilename, Attributes attributes) {
            this.filename = filename;
            this.longFilename = longFilename;
            this.attributes = attributes;
        }
    }

    public static class Attributes {
        public EnumSet<Attribute> flags = EnumSet.noneOf(Attribute.class);
        public long size;
        public int uid;
        public int gid;
        public int perms;
        public int atime;
        public int mtime;

        public Attributes size(long size) {
            this.flags.add(Attribute.Size);
            this.size = size;
            return this;
        }

        public Attributes owner(int uid, int gid) {
            this.flags.add(Attribute.UidGid);
            this.uid = uid;
            this.gid = gid;
            return this;
        }

        public Attributes perms(int perms) {
            this.flags.add(Attribute.Perms);
            this.perms = perms;
            return this;
        }

        public Attributes time(int atime, int mtime) {
            this.flags.add(Attribute.AcModTime);
            this.atime = atime;
            this.mtime = mtime;
            return this;
        }
    }

    public static class Handle {
        public final String id;

        public Handle(String id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        Size,
        UidGid,
        Perms,
        AcModTime;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpenMode {
        Read,
        Write,
        Append,
        Create,
        Truncate,
        Exclusive;

    }
}

