/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.accumulo.AccumuloUtil;
import org.apache.sqoop.hbase.HBaseUtil;
import org.apache.sqoop.mapreduce.AccumuloImportJob;
import org.apache.sqoop.mapreduce.DataDrivenImportJob;
import org.apache.sqoop.mapreduce.HBaseBulkImportJob;
import org.apache.sqoop.mapreduce.HBaseImportJob;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputFormat;
import org.apache.sqoop.mapreduce.mainframe.MainframeImportJob;

public class MainframeManager
extends ConnManager {
    public static final String DEFAULT_DATASET_COLUMN_NAME = "DEFAULT_COLUMN";
    protected SqoopOptions options;
    private static final Log LOG = LogFactory.getLog((String)MainframeManager.class.getName());

    public MainframeManager(SqoopOptions opts) {
        this.options = opts;
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        DataDrivenImportJob importer;
        String pdsName = context.getTableName();
        String jarFile = context.getJarFile();
        SqoopOptions opts = context.getOptions();
        context.setConnManager(this);
        if (opts.getHBaseTable() != null) {
            if (!HBaseUtil.isHBaseJarPresent()) {
                throw new ImportException("HBase jars are not present in classpath, cannot import to HBase!");
            }
            importer = !opts.isBulkLoadEnabled() ? new HBaseImportJob(opts, context) : new HBaseBulkImportJob(opts, context);
        } else if (opts.getAccumuloTable() != null) {
            if (!AccumuloUtil.isAccumuloJarPresent()) {
                throw new ImportException("Accumulo jars are not present in classpath, cannot import to Accumulo!");
            }
            importer = new AccumuloImportJob(opts, context);
        } else {
            importer = new MainframeImportJob(opts, context);
        }
        importer.setInputFormatClass(MainframeDatasetInputFormat.class);
        importer.runImport(pdsName, jarFile, null, opts.getConf());
    }

    @Override
    public String[] getColumnNames(String tableName) {
        String[] colNames = new String[]{DEFAULT_DATASET_COLUMN_NAME};
        return colNames;
    }

    @Override
    public String[] getColumnNamesForTeradata(String tableName) {
        String[] colNames = new String[]{DEFAULT_DATASET_COLUMN_NAME};
        return colNames;
    }

    @Override
    public Map<String, Integer> getColumnTypes(String tableName) {
        HashMap<String, Integer> colTypes = new HashMap<String, Integer>();
        String[] colNames = this.getColumnNames(tableName);
        colTypes.put(colNames[0], 12);
        return colTypes;
    }

    @Override
    public void discardConnection(boolean doClose) {
    }

    @Override
    public String[] listDatabases() {
        LOG.error((Object)"MainframeManager.listDatabases() not supported");
        return null;
    }

    @Override
    public String[] listTables() {
        LOG.error((Object)"MainframeManager.listTables() not supported");
        return null;
    }

    @Override
    public String getPrimaryKey(String tableName) {
        return null;
    }

    @Override
    public ResultSet readTable(String tableName, String[] columns) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public void close() throws SQLException {
        this.release();
    }

    @Override
    public void release() {
    }

    @Override
    public String getDriverClass() {
        return "";
    }

    @Override
    public void execAndPrint(String s) {
    }
}

