/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.connectors.td.TeradataManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.hive.HiveTypes;
import org.apache.sqoop.io.CodecMap;

public class TableDefWriter {
    public static final Log LOG = LogFactory.getLog((String)TableDefWriter.class.getName());
    private SqoopOptions options;
    private ConnManager connManager;
    private Configuration configuration;
    private String inputTableName;
    private String outputTableName;
    private boolean commentsEnabled;
    private Map<String, Integer> externalColTypes;

    public TableDefWriter(SqoopOptions opts, ConnManager connMgr, String inputTable, String outputTable, Configuration config, boolean withComments) {
        this.options = opts;
        this.connManager = connMgr;
        this.inputTableName = inputTable;
        this.outputTableName = outputTable;
        this.configuration = config;
        this.commentsEnabled = withComments;
    }

    public void setColumnTypes(Map<String, Integer> colTypes) {
        this.externalColTypes = colTypes;
        LOG.debug((Object)"Using test-controlled type map");
    }

    private String[] getColumnNames() {
        String[] colNames = this.options.getColumns();
        if (null != colNames) {
            return colNames;
        }
        if (null != this.externalColTypes) {
            ArrayList<String> keyList = new ArrayList<String>();
            for (String key : this.externalColTypes.keySet()) {
                keyList.add(key);
            }
            return keyList.toArray(new String[keyList.size()]);
        }
        if (null != this.inputTableName) {
            if (this.connManager instanceof TeradataManager) {
                return this.connManager.getColumnNamesForTeradata(this.inputTableName);
            }
            return this.connManager.getColumnNames(this.inputTableName);
        }
        return this.connManager.getColumnNamesForQuery(this.options.getSqlQuery());
    }

    public String getCreateTableStmt() throws IOException {
        Properties userMapping = this.options.getMapColumnHive();
        Map<String, Integer> columnTypes = this.externalColTypes != null ? this.externalColTypes : (null != this.inputTableName ? this.connManager.getColumnTypes(this.inputTableName) : this.connManager.getColumnTypesForQuery(this.options.getSqlQuery()));
        String[] colNames = this.getColumnNames();
        StringBuilder sb = new StringBuilder();
        if (this.options.doFailIfHiveTableExists()) {
            sb.append("CREATE TABLE `");
        } else {
            sb.append("CREATE TABLE IF NOT EXISTS `");
        }
        if (this.options.getHiveDatabaseName() != null) {
            sb.append(this.options.getHiveDatabaseName()).append("`.`");
        }
        sb.append(this.outputTableName).append("` ( ");
        for (Object column : userMapping.keySet()) {
            boolean found = false;
            for (String c : colNames) {
                if (!c.equals(column)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("No column by the name " + column + "found while importing data");
        }
        boolean first = true;
        String partitionKey = this.options.getHivePartitionKey();
        for (String col : colNames) {
            if (col.equals(partitionKey)) {
                throw new IllegalArgumentException("Partition key " + col + " cannot " + "be a column to import.");
            }
            if (!first) {
                sb.append(", ");
            }
            first = false;
            Integer colType = columnTypes.get(col);
            String hiveColType = userMapping.getProperty(col);
            if (hiveColType == null) {
                hiveColType = this.connManager.toHiveType(this.inputTableName, col, colType);
            }
            if (null == hiveColType) {
                throw new IOException("Hive does not support the SQL type for column " + col + " from table " + this.inputTableName);
            }
            sb.append('`').append(col).append("` ").append(hiveColType);
            if (!HiveTypes.isHiveTypeImprovised(colType)) continue;
            LOG.warn((Object)("Column " + col + " had to be cast to a less precise type in Hive"));
        }
        sb.append(") ");
        if (this.commentsEnabled) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String curDateStr = dateFormat.format(new Date());
            sb.append("COMMENT 'Imported by sqoop on " + curDateStr + "' ");
        }
        if (partitionKey != null) {
            sb.append("PARTITIONED BY (").append(partitionKey).append(" STRING) ");
        }
        sb.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '");
        sb.append(TableDefWriter.getHiveOctalCharCode(this.options.getOutputFieldDelim()));
        sb.append("' LINES TERMINATED BY '");
        sb.append(TableDefWriter.getHiveOctalCharCode(this.options.getOutputRecordDelim()));
        String codec = this.options.getCompressionCodec();
        if (codec != null && (codec.equals("lzop") || codec.equals(CodecMap.getCodecClassName("lzop")))) {
            sb.append("' STORED AS INPUTFORMAT 'com.hadoop.mapred.DeprecatedLzoTextInputFormat'");
            sb.append(" OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'");
        } else {
            sb.append("' STORED AS TEXTFILE");
        }
        LOG.debug((Object)("Create statement: " + sb.toString()));
        return sb.toString();
    }

    public String getLoadDataStmt() throws IOException {
        Path finalPath = this.getFinalPath();
        StringBuilder sb = new StringBuilder();
        sb.append("LOAD DATA INPATH '");
        sb.append(finalPath.toString() + "'");
        if (this.options.doOverwriteHiveTable()) {
            sb.append(" OVERWRITE");
        }
        sb.append(" INTO TABLE `");
        if (this.options.getHiveDatabaseName() != null) {
            sb.append(this.options.getHiveDatabaseName()).append("`.`");
        }
        sb.append(this.outputTableName);
        sb.append('`');
        if (this.options.getHivePartitionKey() != null) {
            sb.append(" PARTITION (").append(this.options.getHivePartitionKey()).append("='").append(this.options.getHivePartitionValue()).append("')");
        }
        LOG.debug((Object)("Load statement: " + sb.toString()));
        return sb.toString();
    }

    public Path getFinalPath() throws IOException {
        String warehouseDir = this.options.getWarehouseDir();
        if (null == warehouseDir) {
            warehouseDir = "";
        } else if (!warehouseDir.endsWith(File.separator)) {
            warehouseDir = warehouseDir + File.separator;
        }
        String tablePath = null;
        String targetDir = this.options.getTargetDir();
        tablePath = null != targetDir ? warehouseDir + targetDir : warehouseDir + this.inputTableName;
        FileSystem fs = FileSystem.get((Configuration)this.configuration);
        return new Path(tablePath).makeQualified(fs);
    }

    public static String getHiveOctalCharCode(int charNum) {
        if (charNum > 127) {
            throw new IllegalArgumentException("Character " + charNum + " is an out-of-range delimiter");
        }
        return String.format("\\%03o", charNum);
    }
}

