/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class UIRepositoryRole
extends XulEventSourceAdapter
implements IUIRole,
Serializable {
    private static final long serialVersionUID = 6397782451758458788L;
    private IRole rri;

    public UIRepositoryRole() {
    }

    public UIRepositoryRole(IRole rri) {
        this.rri = rri;
    }

    @Override
    public String getName() {
        return this.rri.getName();
    }

    @Override
    public void setName(String name) {
        this.rri.setName(name);
    }

    @Override
    public String getDescription() {
        return this.rri.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.rri.setDescription(description);
    }

    @Override
    public void setUsers(Set<IUIUser> users) {
        HashSet<IUser> rusers = new HashSet<IUser>();
        for (IUIUser user : users) {
            rusers.add(user.getUserInfo());
        }
        this.rri.setUsers(rusers);
    }

    @Override
    public Set<IUIUser> getUsers() {
        HashSet<IUIUser> rusers = new HashSet<IUIUser>();
        for (IUser userInfo : this.rri.getUsers()) {
            try {
                rusers.add(UIObjectRegistry.getInstance().constructUIRepositoryUser(userInfo));
            }
            catch (UIObjectCreationException e) {
                e.printStackTrace();
            }
        }
        return rusers;
    }

    @Override
    public boolean addUser(IUIUser user) {
        return this.rri.addUser(user.getUserInfo());
    }

    @Override
    public boolean removeUser(IUIUser user) {
        return this.removeUser(user.getUserInfo().getLogin());
    }

    @Override
    public void clearUsers() {
        this.rri.clearUsers();
    }

    @Override
    public IRole getRole() {
        return this.rri;
    }

    private boolean removeUser(String userName) {
        IUser userInfo = null;
        for (IUser user : this.rri.getUsers()) {
            if (!user.getLogin().equals(userName)) continue;
            userInfo = user;
            break;
        }
        if (userInfo != null) {
            return this.rri.removeUser(userInfo);
        }
        return false;
    }

    @Override
    public int compareTo(IUIRole o) {
        return this.rri.getName().compareTo(o.getName());
    }
}

