/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.pentaho.di.repository.ObjectRecipient;
import org.pentaho.di.repository.pur.model.ObjectAce;
import org.pentaho.di.repository.pur.model.ObjectAcl;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class UIRepositoryObjectAcls
extends XulEventSourceAdapter
implements Serializable {
    private static final long serialVersionUID = -4576328356619980808L;
    protected ObjectAcl obj;
    private List<UIRepositoryObjectAcl> selectedAclList = new ArrayList<UIRepositoryObjectAcl>();
    private boolean removeEnabled;
    private boolean modelDirty;
    private boolean hasManageAclAccess;

    public void setObjectAcl(ObjectAcl obj) {
        this.obj = obj;
        this.firePropertyChange("acls", null, this.getAcls());
        this.firePropertyChange("entriesInheriting", null, this.isEntriesInheriting());
    }

    public ObjectAcl getObjectAcl() {
        return this.obj;
    }

    public List<UIRepositoryObjectAcl> getAcls() {
        if (this.obj != null) {
            ArrayList<UIRepositoryObjectAcl> acls = new ArrayList<UIRepositoryObjectAcl>();
            for (ObjectAce ace : this.obj.getAces()) {
                acls.add(new UIRepositoryObjectAcl(ace));
            }
            return acls;
        }
        return null;
    }

    public void setAcls(List<UIRepositoryObjectAcl> acls) {
        ArrayList<UIRepositoryObjectAcl> prevousVal = new ArrayList<UIRepositoryObjectAcl>();
        prevousVal.addAll(this.getAcls());
        this.obj.getAces().clear();
        if (acls != null) {
            for (UIRepositoryObjectAcl acl : acls) {
                this.obj.getAces().add(acl.getAce());
            }
        }
        this.firePropertyChange("acls", prevousVal, this.getAcls());
    }

    public void addAcls(List<UIRepositoryObjectAcl> aclsToAdd) {
        this.addAcls(aclsToAdd, false);
    }

    public void addDefaultAcls(List<UIRepositoryObjectAcl> aclsToAdd) {
        this.addAcls(aclsToAdd, true);
    }

    private void addAcls(List<UIRepositoryObjectAcl> aclsToAdd, boolean initializePermissions) {
        for (UIRepositoryObjectAcl acl : aclsToAdd) {
            this.addAcl(acl, initializePermissions);
        }
        this.firePropertyChange("acls", null, this.getAcls());
        if (this.obj.getAces().size() > 0) {
            ArrayList<UIRepositoryObjectAcl> aclList = new ArrayList<UIRepositoryObjectAcl>();
            aclList.add(new UIRepositoryObjectAcl(this.getAceAtIndex(0)));
            this.setSelectedAclList(aclList);
        }
        this.setRemoveEnabled(!this.obj.isEntriesInheriting() && !this.isEmpty() && this.hasManageAclAccess());
        this.setModelDirty(true);
    }

    public void addAcl(UIRepositoryObjectAcl aclToAdd) {
        this.addAcl(aclToAdd, false);
    }

    public void addDefaultAcl(UIRepositoryObjectAcl aclToAdd) {
        this.addAcl(aclToAdd, true);
    }

    private void addAcl(UIRepositoryObjectAcl aclToAdd, boolean initializePermissions) {
        if (initializePermissions) {
            EnumSet<RepositoryFilePermission> initialialPermisson = EnumSet.of(RepositoryFilePermission.READ);
            aclToAdd.setPermissionSet(initialialPermisson);
        }
        this.obj.getAces().add(aclToAdd.getAce());
    }

    public void removeAcls(List<UIRepositoryObjectAcl> aclsToRemove) {
        for (UIRepositoryObjectAcl acl : aclsToRemove) {
            this.removeAcl(acl.getRecipientName());
        }
        this.firePropertyChange("acls", null, this.getAcls());
        if (this.obj.getAces().size() > 0) {
            ArrayList<UIRepositoryObjectAcl> aclList = new ArrayList<UIRepositoryObjectAcl>();
            aclList.add(new UIRepositoryObjectAcl(this.getAceAtIndex(0)));
            this.setSelectedAclList(aclList);
        } else {
            this.setSelectedAclList(null);
        }
        this.setRemoveEnabled(!this.obj.isEntriesInheriting() && !this.isEmpty() && this.hasManageAclAccess());
        this.setModelDirty(true);
    }

    public void removeAcl(String recipientName) {
        ObjectAce aceToRemove = null;
        for (ObjectAce ace : this.obj.getAces()) {
            if (!ace.getRecipient().getName().equals(recipientName)) continue;
            aceToRemove = ace;
            break;
        }
        this.obj.getAces().remove(aceToRemove);
    }

    public void removeSelectedAcls() {
        ArrayList<UIRepositoryObjectAcl> removalList = new ArrayList<UIRepositoryObjectAcl>();
        for (UIRepositoryObjectAcl rem : this.getSelectedAclList()) {
            removalList.add(rem);
        }
        this.removeAcls(removalList);
    }

    public void updateAcl(UIRepositoryObjectAcl aclToUpdate) {
        List<ObjectAce> aces = this.obj.getAces();
        for (ObjectAce ace : aces) {
            if (!ace.getRecipient().getName().equals(aclToUpdate.getRecipientName())) continue;
            ace.setPermissions(aclToUpdate.getPermissionSet());
        }
        UIRepositoryObjectAcl acl = this.getAcl(aclToUpdate.getRecipientName());
        acl.setPermissionSet(aclToUpdate.getPermissionSet());
        this.firePropertyChange("acls", null, this.getAcls());
        this.selectedAclList.clear();
        ArrayList<UIRepositoryObjectAcl> aclList = new ArrayList<UIRepositoryObjectAcl>();
        aclList.add(aclToUpdate);
        this.setSelectedAclList(aclList);
        this.setModelDirty(true);
    }

    public UIRepositoryObjectAcl getAcl(String recipient) {
        for (ObjectAce ace : this.obj.getAces()) {
            if (!ace.getRecipient().getName().equals(recipient)) continue;
            return new UIRepositoryObjectAcl(ace);
        }
        return null;
    }

    public List<UIRepositoryObjectAcl> getSelectedAclList() {
        return this.selectedAclList;
    }

    public void setSelectedAclList(List<UIRepositoryObjectAcl> list) {
        if (this.selectedAclList != null && this.selectedAclList.equals(list)) {
            return;
        }
        ArrayList<UIRepositoryObjectAcl> previousVal = new ArrayList<UIRepositoryObjectAcl>();
        previousVal.addAll(this.selectedAclList);
        this.selectedAclList.clear();
        if (list != null) {
            this.selectedAclList.addAll(list);
            this.firePropertyChange("selectedAclList", previousVal, list);
        }
        this.setRemoveEnabled(!this.isEntriesInheriting() && !this.isEmpty() && this.hasManageAclAccess());
    }

    public boolean isEntriesInheriting() {
        if (this.obj != null) {
            return this.obj.isEntriesInheriting();
        }
        return false;
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        if (this.obj != null) {
            boolean previousVal = this.isEntriesInheriting();
            this.obj.setEntriesInheriting(entriesInheriting);
            this.firePropertyChange("entriesInheriting", previousVal, entriesInheriting);
            this.setSelectedAclList(null);
            this.setRemoveEnabled(!entriesInheriting && !this.isEmpty() && this.hasManageAclAccess());
            if (previousVal != entriesInheriting) {
                this.setModelDirty(true);
            }
        }
    }

    public ObjectRecipient getOwner() {
        if (this.obj != null) {
            return this.obj.getOwner();
        }
        return null;
    }

    public void setRemoveEnabled(boolean removeEnabled) {
        this.removeEnabled = removeEnabled;
        this.firePropertyChange("removeEnabled", null, removeEnabled);
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public int getAceIndex(ObjectAce ace) {
        List<ObjectAce> aceList = this.obj.getAces();
        for (int i = 0; i < aceList.size(); ++i) {
            if (!ace.equals(aceList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public ObjectAce getAceAtIndex(int index) {
        if (index >= 0) {
            return this.obj.getAces().get(index);
        }
        return null;
    }

    public void setModelDirty(boolean modelDirty) {
        this.modelDirty = modelDirty;
    }

    public boolean isModelDirty() {
        return this.modelDirty;
    }

    public boolean hasManageAclAccess() {
        return this.hasManageAclAccess;
    }

    public void setHasManageAclAccess(boolean hasManageAclAccess) {
        this.hasManageAclAccess = hasManageAclAccess;
    }

    public void clear() {
        this.setRemoveEnabled(false);
        this.setModelDirty(false);
        this.setAcls(null);
        this.setSelectedAclList(null);
        this.setHasManageAclAccess(false);
    }

    private boolean isEmpty() {
        return this.getSelectedAclList() == null || this.getSelectedAclList().size() <= 0;
    }
}

