/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.repository.ObjectRecipient;
import org.pentaho.di.repository.pur.model.RepositoryObjectAce;
import org.pentaho.di.repository.pur.model.RepositoryObjectRecipient;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcl;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcls;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class UIRepositoryObjectAclModel
extends XulEventSourceAdapter
implements Serializable {
    private static final long serialVersionUID = 2403228456811971640L;
    private List<String> masterAvailableUserList;
    private List<String> masterAvailableRoleList;
    private UIRepositoryObjectAcls selectedAcls;
    private List<String> selectedAvailableRoles = new ArrayList<String>();
    private List<String> selectedAvailableUsers = new ArrayList<String>();
    private List<UIRepositoryObjectAcl> selectedAssignedRoles = new ArrayList<UIRepositoryObjectAcl>();
    private List<UIRepositoryObjectAcl> selectedAssignedUsers = new ArrayList<UIRepositoryObjectAcl>();
    private List<UIRepositoryObjectAcl> aclsToAdd;
    private List<UIRepositoryObjectAcl> aclsToRemove;
    private List<String> availableUserList = new ArrayList<String>();
    private List<String> availableRoleList = new ArrayList<String>();
    private boolean userAssignmentPossible;
    private boolean userUnassignmentPossible;
    private boolean roleAssignmentPossible;
    private boolean roleUnassignmentPossible;

    public UIRepositoryObjectAclModel(UIRepositoryObjectAcls acls) {
        this.masterAvailableUserList = new ArrayList<String>();
        this.masterAvailableRoleList = new ArrayList<String>();
        this.aclsToAdd = new ArrayList<UIRepositoryObjectAcl>();
        this.aclsToRemove = new ArrayList<UIRepositoryObjectAcl>();
        this.selectedAcls = acls;
    }

    public List<UIRepositoryObjectAcl> getAclsToAdd() {
        return this.aclsToAdd;
    }

    public void setAclsToRemove(List<UIRepositoryObjectAcl> aclsToRemove) {
        this.aclsToRemove = aclsToRemove;
    }

    public List<String> getSelectedAvailableRoles() {
        return this.selectedAvailableRoles;
    }

    public void setSelectedAvailableRoles(List<String> selectedAvailableRoles) {
        if (this.selectedAvailableRoles != null && this.selectedAvailableRoles.equals(selectedAvailableRoles)) {
            return;
        }
        ArrayList<String> previousVal = new ArrayList<String>();
        previousVal.addAll(this.selectedAvailableRoles);
        this.selectedAvailableRoles.clear();
        for (String role : selectedAvailableRoles) {
            this.selectedAvailableRoles.add(role);
        }
        this.firePropertyChange("selectedAvailableRoles", previousVal, this.selectedAvailableRoles);
        this.fireAssignPropertyChangeEvent(ObjectRecipient.Type.ROLE);
    }

    public void setSelectedAvailableRole(String selectedAvailableRole) {
        this.selectedAvailableRoles.add(selectedAvailableRole);
    }

    public List<String> getSelectedAvailableUsers() {
        return this.selectedAvailableUsers;
    }

    public void setSelectedAvailableUsers(List<String> selectedAvailableUsers) {
        if (this.selectedAvailableUsers != null && this.selectedAvailableUsers.equals(selectedAvailableUsers)) {
            return;
        }
        ArrayList<String> previousVal = new ArrayList<String>();
        previousVal.addAll(this.selectedAvailableUsers);
        this.selectedAvailableUsers.clear();
        for (String user : selectedAvailableUsers) {
            this.selectedAvailableUsers.add(user);
        }
        this.firePropertyChange("selectedAvailableUsers", previousVal, this.selectedAvailableUsers);
        this.fireAssignPropertyChangeEvent(ObjectRecipient.Type.USER);
    }

    public void setSelectedAvailableUser(String selectedAvailableUser) {
        this.selectedAvailableUsers.add(selectedAvailableUser);
    }

    public List<UIRepositoryObjectAcl> getSelectedAssignedRoles() {
        return this.selectedAssignedRoles;
    }

    public void setSelectedAssignedRoles(List<UIRepositoryObjectAcl> selectedAssignedRoles) {
        if (this.selectedAssignedRoles != null && this.selectedAssignedRoles.equals(selectedAssignedRoles)) {
            return;
        }
        ArrayList<UIRepositoryObjectAcl> previousVal = new ArrayList<UIRepositoryObjectAcl>();
        previousVal.addAll(this.selectedAssignedRoles);
        this.selectedAssignedRoles.clear();
        for (UIRepositoryObjectAcl role : selectedAssignedRoles) {
            this.selectedAssignedRoles.add(role);
        }
        this.firePropertyChange("selectedAssignedRoles", previousVal, this.selectedAssignedRoles);
        this.fireUnassignPropertyChangeEvent(ObjectRecipient.Type.ROLE);
    }

    public List<UIRepositoryObjectAcl> getSelectedAssignedUsers() {
        return this.selectedAssignedUsers;
    }

    public void setSelectedAssignedUsers(List<UIRepositoryObjectAcl> selectedAssignedUsers) {
        if (this.selectedAssignedUsers != null && this.selectedAssignedUsers.equals(selectedAssignedUsers)) {
            return;
        }
        ArrayList<UIRepositoryObjectAcl> previousVal = new ArrayList<UIRepositoryObjectAcl>();
        previousVal.addAll(this.selectedAssignedUsers);
        this.selectedAssignedUsers.clear();
        for (UIRepositoryObjectAcl user : selectedAssignedUsers) {
            this.selectedAssignedUsers.add(user);
        }
        this.firePropertyChange("selectedAssignedUsers", previousVal, this.selectedAssignedUsers);
        this.fireUnassignPropertyChangeEvent(ObjectRecipient.Type.USER);
    }

    public void setSelectedAssignedUser(UIRepositoryObjectAcl selectedAssignedUser) {
        this.selectedAssignedUsers.add(selectedAssignedUser);
    }

    public List<String> getAvailableUserList() {
        return this.availableUserList;
    }

    public boolean isUserAssignmentPossible() {
        return this.userAssignmentPossible;
    }

    public void setUserAssignmentPossible(boolean userAssignmentPossible) {
        this.userAssignmentPossible = userAssignmentPossible;
        this.fireAssignPropertyChangeEvent(ObjectRecipient.Type.USER);
    }

    public boolean isUserUnassignmentPossible() {
        return this.userUnassignmentPossible;
    }

    public void setUserUnassignmentPossible(boolean userUnassignmentPossible) {
        this.userUnassignmentPossible = userUnassignmentPossible;
        this.fireUnassignPropertyChangeEvent(ObjectRecipient.Type.USER);
    }

    public boolean isRoleAssignmentPossible() {
        return this.roleAssignmentPossible;
    }

    public void setRoleAssignmentPossible(boolean roleAssignmentPossible) {
        this.roleAssignmentPossible = roleAssignmentPossible;
        this.fireAssignPropertyChangeEvent(ObjectRecipient.Type.ROLE);
    }

    public boolean isRoleUnassignmentPossible() {
        return this.roleUnassignmentPossible;
    }

    public void setRoleUnassignmentPossible(boolean roleUnassignmentPossible) {
        this.roleUnassignmentPossible = roleUnassignmentPossible;
        this.fireUnassignPropertyChangeEvent(ObjectRecipient.Type.ROLE);
    }

    public void setAclsList(List<String> userList, List<String> roleList) {
        if (userList != null && userList.size() > 0) {
            this.setAvailableUserList(userList);
            this.setSelectedAvailableUser(userList.get(0));
            this.masterAvailableUserList.addAll(this.availableUserList);
        }
        if (roleList != null && roleList.size() > 0) {
            this.setAvailableRoleList(roleList);
            this.setSelectedAvailableRole(roleList.get(0));
            this.masterAvailableRoleList.addAll(this.availableRoleList);
        }
        this.setSelectedAcls(this.selectedAcls);
    }

    public void setAvailableUserList(List<String> userList) {
        ArrayList<String> previousVal = new ArrayList<String>();
        previousVal.addAll(this.availableUserList);
        this.availableUserList.clear();
        this.availableUserList.addAll(userList);
        this.firePropertyChange("availableUserList", previousVal, this.availableUserList);
    }

    public List<String> getAvailableRoleList() {
        return this.availableRoleList;
    }

    public void setAvailableRoleList(List<String> roleList) {
        ArrayList<String> previousVal = new ArrayList<String>();
        previousVal.addAll(this.availableRoleList);
        this.availableRoleList.clear();
        this.availableRoleList.addAll(roleList);
        this.firePropertyChange("availableRoleList", previousVal, this.availableRoleList);
    }

    public void assignRoles(List<Object> rolesToAssign) {
        ArrayList<UIRepositoryObjectAcl> acls = new ArrayList<UIRepositoryObjectAcl>();
        for (Object role : rolesToAssign) {
            if (!(role instanceof String)) continue;
            String roleToAssign = (String)role;
            acls.add(this.assignRole(roleToAssign));
        }
        this.firePropertyChange("selectedRoleList", null, this.getSelectedRoleList());
        this.setSelectedAssignedRoles(acls);
        this.setSelectedAvailableRoles(new ArrayList<String>());
    }

    public UIRepositoryObjectAcl assignRole(String roleToAssign) {
        UIRepositoryObjectAcl acl = this.createAclFromRole(roleToAssign);
        this.aclsToAdd.add(acl);
        this.removeFromAvailableRoles(roleToAssign);
        return acl;
    }

    public UIRepositoryObjectAcl getAcl(String aclName) {
        for (UIRepositoryObjectAcl selected : this.selectedAcls.getAcls()) {
            if (!selected.getRecipientName().equals(aclName)) continue;
            return selected;
        }
        for (UIRepositoryObjectAcl selected : this.aclsToAdd) {
            if (!selected.getRecipientName().equals(aclName)) continue;
            return selected;
        }
        return null;
    }

    public void unassign(List<Object> toUnassign) {
        ObjectRecipient.Type type = null;
        ArrayList<String> unassignList = new ArrayList<String>();
        for (Object obj : toUnassign) {
            if (!(obj instanceof UIRepositoryObjectAcl)) continue;
            UIRepositoryObjectAcl acl = (UIRepositoryObjectAcl)obj;
            type = acl.getRecipientType();
            this.unassign(acl.getRecipientName());
            unassignList.add(acl.getRecipientName());
        }
        if (type == ObjectRecipient.Type.ROLE) {
            this.setSelectedAvailableRoles(unassignList);
            this.setSelectedAssignedRoles(new ArrayList<UIRepositoryObjectAcl>());
        } else {
            this.setSelectedAvailableUsers(unassignList);
            this.setSelectedAssignedUsers(new ArrayList<UIRepositoryObjectAcl>());
        }
    }

    private void unassign(String toUnassign) {
        UIRepositoryObjectAcl selectedAcl = this.getAcl(toUnassign);
        if (selectedAcl != null) {
            this.unassign(selectedAcl);
            if (selectedAcl.getRecipientType() == ObjectRecipient.Type.USER) {
                this.addToAvailableUsers(selectedAcl.getRecipientName());
            } else if (selectedAcl.getRecipientType() == ObjectRecipient.Type.ROLE) {
                this.addToAvailableRoles(selectedAcl.getRecipientName());
            }
        }
    }

    private void unassign(UIRepositoryObjectAcl toUnassign) {
        if (this.aclsToAdd.contains(toUnassign)) {
            this.aclsToAdd.remove(toUnassign);
        } else {
            this.aclsToRemove.add(toUnassign);
        }
        if (toUnassign.getRecipientType() == ObjectRecipient.Type.ROLE) {
            this.firePropertyChange("selectedRoleList", null, this.getSelectedRoleList());
        } else if (toUnassign.getRecipientType() == ObjectRecipient.Type.USER) {
            this.firePropertyChange("selectedUserList", null, this.getSelectedUserList());
        }
    }

    public void assignUsers(List<Object> usersToAssign) {
        ArrayList<UIRepositoryObjectAcl> previousVal = new ArrayList<UIRepositoryObjectAcl>();
        previousVal.addAll(this.getSelectedUserList());
        ArrayList<UIRepositoryObjectAcl> assignList = new ArrayList<UIRepositoryObjectAcl>();
        for (Object user : usersToAssign) {
            if (!(user instanceof String)) continue;
            assignList.add(this.assignUser((String)user));
        }
        this.firePropertyChange("selectedUserList", null, this.getSelectedUserList());
        this.setSelectedAssignedUsers(assignList);
        this.setSelectedAvailableUsers(new ArrayList<String>());
    }

    public UIRepositoryObjectAcl assignUser(String userToAssign) {
        UIRepositoryObjectAcl acl = this.createAclFromUser(userToAssign);
        this.aclsToAdd.add(acl);
        this.removeFromAvailableUsers(userToAssign);
        return acl;
    }

    private void removeFromAvailableAcls(UIRepositoryObjectAcl acl) {
        if (acl.getRecipientType().equals((Object)ObjectRecipient.Type.ROLE)) {
            this.removeFromAvailableRoles(acl.getRecipientName());
        } else if (acl.getRecipientType().equals((Object)ObjectRecipient.Type.USER)) {
            this.removeFromAvailableUsers(acl.getRecipientName());
        }
    }

    public UIRepositoryObjectAcls getSelectedAcls() {
        return this.selectedAcls;
    }

    public void setSelectedAcls(UIRepositoryObjectAcls selectedAcls) {
        this.selectedAcls = selectedAcls;
        for (UIRepositoryObjectAcl acl : this.selectedAcls.getAcls()) {
            this.removeFromAvailableAcls(acl);
        }
        this.firePropertyChange("selectedUserList", null, this.getSelectedUserList());
        this.firePropertyChange("selectedRoleList", null, this.getSelectedRoleList());
    }

    public List<UIRepositoryObjectAcl> getSelectedUserList() {
        if (this.selectedAcls != null && this.selectedAcls.getAcls() != null) {
            ArrayList<UIRepositoryObjectAcl> selectedUserList = new ArrayList<UIRepositoryObjectAcl>();
            for (UIRepositoryObjectAcl selectedAcl : this.selectedAcls.getAcls()) {
                if (this.findByRecipientName(selectedAcl.getRecipientName()) || !selectedAcl.getRecipientType().equals((Object)ObjectRecipient.Type.USER)) continue;
                selectedUserList.add(selectedAcl);
            }
            for (UIRepositoryObjectAcl acl : this.aclsToAdd) {
                if (!acl.getRecipientType().equals((Object)ObjectRecipient.Type.USER)) continue;
                selectedUserList.add(acl);
            }
            return selectedUserList;
        }
        return null;
    }

    public List<UIRepositoryObjectAcl> getSelectedRoleList() {
        if (this.selectedAcls != null && this.selectedAcls.getAcls() != null) {
            ArrayList<UIRepositoryObjectAcl> selectedRoleList = new ArrayList<UIRepositoryObjectAcl>();
            for (UIRepositoryObjectAcl selectedAcl : this.selectedAcls.getAcls()) {
                if (this.findByRecipientName(selectedAcl.getRecipientName()) || !selectedAcl.getRecipientType().equals((Object)ObjectRecipient.Type.ROLE)) continue;
                selectedRoleList.add(selectedAcl);
            }
            for (UIRepositoryObjectAcl acl : this.aclsToAdd) {
                if (!acl.getRecipientType().equals((Object)ObjectRecipient.Type.ROLE)) continue;
                selectedRoleList.add(acl);
            }
            return selectedRoleList;
        }
        return null;
    }

    public String getAvailableUser(int index) {
        return this.availableUserList.get(index);
    }

    public int getAvailableUserIndex(String user) {
        for (int i = 0; i < this.availableUserList.size(); ++i) {
            String u = this.availableUserList.get(i);
            if (!u.equals(user)) continue;
            return i;
        }
        return -1;
    }

    public String getAvailableRole(int index) {
        return this.availableRoleList.get(index);
    }

    public int getAvailableRoleIndex(String role) {
        for (int i = 0; i < this.availableRoleList.size(); ++i) {
            String r = this.availableRoleList.get(i);
            if (!r.equals(role)) continue;
            return i;
        }
        return -1;
    }

    private UIRepositoryObjectAcl createAclFromRole(String role) {
        RepositoryObjectAce ace = new RepositoryObjectAce(new RepositoryObjectRecipient(role, ObjectRecipient.Type.ROLE));
        return new UIRepositoryObjectAcl(ace);
    }

    private UIRepositoryObjectAcl createAclFromUser(String user) {
        RepositoryObjectAce ace = new RepositoryObjectAce(new RepositoryObjectRecipient(user, ObjectRecipient.Type.USER));
        return new UIRepositoryObjectAcl(ace);
    }

    private void removeFromAvailableUsers(String name) {
        for (String user : this.availableUserList) {
            if (!user.equals(name)) continue;
            this.availableUserList.remove(user);
            break;
        }
        this.firePropertyChange("availableUserList", null, this.availableUserList);
    }

    private void removeFromAvailableRoles(String name) {
        for (String role : this.availableRoleList) {
            if (!role.equals(name)) continue;
            this.availableRoleList.remove(role);
            break;
        }
        this.firePropertyChange("availableRoleList", null, this.availableRoleList);
    }

    private void addToAvailableUsers(String name) {
        for (String user : this.masterAvailableUserList) {
            if (!user.equals(name)) continue;
            this.availableUserList.add(user);
            break;
        }
        this.firePropertyChange("availableUserList", null, this.availableUserList);
        this.fireAssignPropertyChangeEvent(ObjectRecipient.Type.USER);
    }

    private void addToAvailableRoles(String name) {
        for (String role : this.masterAvailableRoleList) {
            if (!role.equals(name)) continue;
            this.availableRoleList.add(role);
            break;
        }
        this.firePropertyChange("availableRoleList", null, this.availableRoleList);
        this.fireAssignPropertyChangeEvent(ObjectRecipient.Type.ROLE);
    }

    public boolean findByRecipientName(String recipientName) {
        for (UIRepositoryObjectAcl acl : this.aclsToRemove) {
            if (!acl.getRecipientName().equals(recipientName)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.aclsToAdd.clear();
        this.aclsToRemove.clear();
        this.masterAvailableRoleList.clear();
        this.masterAvailableUserList.clear();
        this.availableRoleList.clear();
        this.availableUserList.clear();
        this.selectedAvailableRoles.clear();
        this.selectedAvailableUsers.clear();
        this.selectedAssignedRoles.clear();
        this.selectedAssignedUsers.clear();
        this.setRoleAssignmentPossible(false);
        this.setRoleUnassignmentPossible(false);
        this.setUserAssignmentPossible(false);
        this.setUserUnassignmentPossible(false);
    }

    public void updateSelectedAcls() {
        this.selectedAcls.addDefaultAcls(this.aclsToAdd);
        this.selectedAcls.removeAcls(this.aclsToRemove);
    }

    public UIRepositoryObjectAcl getSelectedUser(int index) {
        return this.getSelectedUserList().get(index);
    }

    public int getSelectedUserIndex(UIRepositoryObjectAcl user) {
        List<UIRepositoryObjectAcl> userList = this.getSelectedUserList();
        for (int i = 0; i < userList.size(); ++i) {
            UIRepositoryObjectAcl u = userList.get(i);
            if (!u.getRecipientName().equals(user.getRecipientName())) continue;
            return i;
        }
        return -1;
    }

    public UIRepositoryObjectAcl getSelectedRole(int index) {
        return this.getSelectedRoleList().get(index);
    }

    public int getSelectedRoleIndex(UIRepositoryObjectAcl role) {
        List<UIRepositoryObjectAcl> roleList = this.getSelectedRoleList();
        for (int i = 0; i < roleList.size(); ++i) {
            UIRepositoryObjectAcl r = roleList.get(i);
            if (!r.getRecipientName().equals(role.getRecipientName())) continue;
            return i;
        }
        return -1;
    }

    private void fireUnassignPropertyChangeEvent(ObjectRecipient.Type type) {
        if (type == ObjectRecipient.Type.USER) {
            if (this.isUnAssignmentPossible(type)) {
                this.firePropertyChange("userUnassignmentPossible", null, true);
            } else {
                this.firePropertyChange("userUnassignmentPossible", null, false);
            }
        } else if (this.isUnAssignmentPossible(type)) {
            this.firePropertyChange("roleUnassignmentPossible", null, true);
        } else {
            this.firePropertyChange("roleUnassignmentPossible", null, false);
        }
    }

    private void fireAssignPropertyChangeEvent(ObjectRecipient.Type type) {
        if (type == ObjectRecipient.Type.USER) {
            if (this.isAssignmentPossible(type)) {
                this.firePropertyChange("userAssignmentPossible", null, true);
            } else {
                this.firePropertyChange("userAssignmentPossible", null, false);
            }
        } else if (this.isAssignmentPossible(type)) {
            this.firePropertyChange("roleAssignmentPossible", null, true);
        } else {
            this.firePropertyChange("roleAssignmentPossible", null, false);
        }
    }

    private boolean isUnAssignmentPossible(ObjectRecipient.Type type) {
        if (type == ObjectRecipient.Type.USER) {
            return this.selectedAssignedUsers != null && this.selectedAssignedUsers.size() > 0;
        }
        return this.selectedAssignedRoles != null && this.selectedAssignedRoles.size() > 0;
    }

    private boolean isAssignmentPossible(ObjectRecipient.Type type) {
        if (type == ObjectRecipient.Type.USER) {
            return this.selectedAvailableUsers != null && this.selectedAvailableUsers.size() > 0;
        }
        return this.selectedAvailableRoles != null && this.selectedAvailableRoles.size() > 0;
    }
}

