/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.UIEEObjectRegistery;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryRole;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurity;

public class UIEESecurity
extends UISecurity
implements Serializable {
    private static final long serialVersionUID = -1835729731278502930L;
    protected IUIRole selectedRole;
    private int selectedRoleIndex;
    protected List<IUIRole> roleList = new ArrayList<IUIRole>();
    protected IUIRole selectedSystemRole;
    private int selectedSystemRoleIndex;
    protected List<IUIRole> systemRoleList = new ArrayList<IUIRole>();
    private static final String AUTHENTICATED = "Authenticated";
    private static final String ANONYMOUS = "Anonymous";

    public UIEESecurity() {
    }

    public UIEESecurity(RepositorySecurityManager rsm) throws Exception {
        super(rsm);
        if (rsm instanceof IRoleSupportSecurityManager) {
            for (IRole role : ((IRoleSupportSecurityManager)rsm).getRoles()) {
                if (role.getName().equals(AUTHENTICATED) || role.getName().equals(ANONYMOUS)) continue;
                IUIRole newRole = UIEEObjectRegistery.getInstance().constructUIRepositoryRole(role);
                this.roleList.add(newRole);
            }
        }
        Collections.sort(this.roleList);
        this.firePropertyChange("roleList", null, this.roleList);
        IRole authenticatedSystemRole = ((IRoleSupportSecurityManager)rsm).constructRole();
        IRole anonymousSystemRole = ((IRoleSupportSecurityManager)rsm).constructRole();
        authenticatedSystemRole.setName(AUTHENTICATED);
        authenticatedSystemRole.setDescription(AUTHENTICATED);
        anonymousSystemRole.setName(ANONYMOUS);
        anonymousSystemRole.setDescription(ANONYMOUS);
        this.systemRoleList.add(UIEEObjectRegistery.getInstance().constructUIRepositoryRole(authenticatedSystemRole));
        this.systemRoleList.add(UIEEObjectRegistery.getInstance().constructUIRepositoryRole(anonymousSystemRole));
        Collections.sort(this.systemRoleList);
        this.firePropertyChange("systemRoleList", null, this.systemRoleList);
    }

    public int getSelectedRoleIndex() {
        return this.selectedRoleIndex;
    }

    public void setSelectedRoleIndex(int selectedRoleIndex) {
        this.selectedRoleIndex = selectedRoleIndex;
        this.firePropertyChange("selectedRoleIndex", null, selectedRoleIndex);
    }

    public int getSelectedSystemRoleIndex() {
        return this.selectedSystemRoleIndex;
    }

    public void setSelectedSystemRoleIndex(int selectedSystemRoleIndex) {
        this.selectedSystemRoleIndex = selectedSystemRoleIndex;
        this.firePropertyChange("selectedSystemRoleIndex", null, selectedSystemRoleIndex);
    }

    public IUIRole getSelectedRole() {
        return this.selectedRole;
    }

    public void setSelectedRole(IUIRole selectedRole) {
        this.selectedRole = selectedRole;
        this.firePropertyChange("selectedRole", null, selectedRole);
        this.setSelectedRoleIndex(this.getIndexOfRole(selectedRole));
    }

    public IUIRole getSelectedSystemRole() {
        return this.selectedSystemRole;
    }

    public void setSelectedSystemRole(IUIRole selectedSystemRole) {
        this.selectedSystemRole = selectedSystemRole;
        this.firePropertyChange("selectedSystemRole", null, selectedSystemRole);
        this.setSelectedSystemRoleIndex(this.getIndexOfSystemRole(selectedSystemRole));
    }

    public List<IUIRole> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<IUIRole> roleList) {
        this.roleList.clear();
        this.roleList.addAll(roleList);
        this.firePropertyChange("roleList", null, roleList);
    }

    public List<IUIRole> getSystemRoleList() {
        return this.systemRoleList;
    }

    public void setSystemRoleList(List<IUIRole> systemRoleList) {
        this.systemRoleList.clear();
        this.systemRoleList.addAll(systemRoleList);
        this.firePropertyChange("systemRoleList", null, systemRoleList);
    }

    public void addRole(IUIRole roleToAdd) {
        this.roleList.add(roleToAdd);
        Collections.sort(this.roleList);
        this.firePropertyChange("roleList", null, this.roleList);
        for (IUIUser userInfo : roleToAdd.getUsers()) {
            this.assignRoleToUser(userInfo, roleToAdd);
        }
        this.setSelectedRole(roleToAdd);
    }

    public void updateUser(IUIUser userToUpdate, Set<IUIRole> previousRoleList) {
        IUIUser user = this.getUser(userToUpdate.getName());
        user.setDescription(userToUpdate.getDescription());
        if (userToUpdate instanceof IUIEEUser) {
            ((IUIEEUser)user).setRoles(((IUIEEUser)userToUpdate).getRoles());
        }
        this.firePropertyChange("userList", null, this.userList);
        this.updateUserInRoles(userToUpdate, previousRoleList, ((IUIEEUser)userToUpdate).getRoles());
        this.setSelectedUser(user);
    }

    public void updateRole(IUIRole roleToUpdate, Set<IUIUser> previousUserList) {
        IUIRole role = this.getRole(roleToUpdate.getName());
        role.setDescription(roleToUpdate.getDescription());
        role.setUsers(roleToUpdate.getUsers());
        this.firePropertyChange("roleList", null, this.roleList);
        this.updateRoleInUsers(roleToUpdate, previousUserList, roleToUpdate.getUsers());
        this.setSelectedRole(role);
    }

    public void removeRole(String name) {
        this.removeRole(this.getRole(name));
    }

    public void removeRole(IUIRole roleToRemove) {
        int index = this.getIndexOfRole(roleToRemove);
        this.roleList.remove(roleToRemove);
        this.firePropertyChange("roleList", null, this.roleList);
        for (IUIUser userInfo : roleToRemove.getUsers()) {
            this.unassignRoleFromUser(userInfo, roleToRemove);
        }
        if (index - 1 >= 0) {
            this.setSelectedRole(this.getRoleAtIndex(index - 1));
        }
    }

    public void addUser(IUIUser userToAdd) {
        this.userList.add(userToAdd);
        Collections.sort(this.userList);
        this.firePropertyChange("userList", null, this.userList);
        if (userToAdd instanceof IUIEEUser) {
            for (IUIRole role : ((IUIEEUser)userToAdd).getRoles()) {
                this.assignUserToRole(role, userToAdd);
            }
        }
        this.setSelectedUser(userToAdd);
    }

    public void removeUser(IUIUser userToRemove) {
        int index = this.getIndexOfUser(userToRemove);
        this.userList.remove(userToRemove);
        this.firePropertyChange("userList", null, this.userList);
        if (userToRemove instanceof IUIEEUser) {
            for (IUIRole role : ((IUIEEUser)userToRemove).getRoles()) {
                this.unassignUserFromRole(role, userToRemove);
            }
        }
        if (index - 1 >= 0) {
            this.setSelectedUser(this.getUserAtIndex(index - 1));
        }
    }

    private void updateUserInRoles(IUIUser user, Set<IUIRole> userRolesBeforeUpdate, Set<IUIRole> userRolesAfterUpdate) {
        for (IUIRole role : userRolesBeforeUpdate) {
            if (this.exist(role, userRolesAfterUpdate)) continue;
            this.unassignUserFromRole(role, user);
        }
        for (IUIRole role : userRolesAfterUpdate) {
            if (this.exist(role, userRolesBeforeUpdate)) continue;
            this.assignUserToRole(role, user);
        }
    }

    private boolean exist(IUIRole role, Set<IUIRole> roleSet) {
        for (IUIRole roleInfo : roleSet) {
            if (!role.getName().equals(roleInfo.getName())) continue;
            return true;
        }
        return false;
    }

    private void updateRoleInUsers(IUIRole role, Set<IUIUser> roleUsersBeforeUpdate, Set<IUIUser> roleUsersAfterUpdate) {
        for (IUIUser userInfo : roleUsersBeforeUpdate) {
            if (this.exist(userInfo, roleUsersAfterUpdate)) continue;
            this.unassignRoleFromUser(userInfo, role);
        }
        for (IUIUser userInfo : roleUsersAfterUpdate) {
            if (this.exist(userInfo, roleUsersBeforeUpdate)) continue;
            this.assignRoleToUser(userInfo, role);
        }
    }

    private boolean exist(IUIUser ruser, Set<IUIUser> users) {
        for (IUIUser user : users) {
            if (!user.getName().equals(ruser.getName())) continue;
            return true;
        }
        return false;
    }

    private IUIRole getRole(String name) {
        for (IUIRole role : this.roleList) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public void removeRolesFromSelectedUser(Collection<Object> roles) {
        for (Object o : roles) {
            UIRepositoryRole role = (UIRepositoryRole)o;
            this.removeRoleFromSelectedUser(role.getName());
        }
        this.firePropertyChange("selectedUser", null, this.selectedUser);
    }

    private void removeRoleFromSelectedUser(String roleName) {
        IUIRole role = this.findRoleInSelectedUser(roleName);
        if (this.selectedUser instanceof IUIEEUser) {
            ((IUIEEUser)this.selectedUser).removeRole(role);
        }
        this.unassignUserFromRole(role, this.selectedUser);
    }

    public void removeUsersFromSelectedRole(Collection<Object> users) {
        for (Object o : users) {
            IUIUser user = (IUIUser)o;
            this.removeUserFromSelectedRole(user.getName());
        }
        this.firePropertyChange("selectedRole", null, this.selectedRole);
    }

    private void removeUserFromSelectedRole(String userName) {
        IUIUser user = this.findUserInSelectedRole(userName);
        this.selectedRole.removeUser(user);
        this.unassignRoleFromUser(user, this.selectedRole);
    }

    private IUIRole findRoleInSelectedUser(String roleName) {
        if (this.selectedUser instanceof IUIEEUser) {
            Set<IUIRole> roles = ((IUIEEUser)this.selectedUser).getRoles();
            for (IUIRole role : roles) {
                if (!role.getName().equals(roleName)) continue;
                return role;
            }
        }
        return null;
    }

    private IUIUser findUserInSelectedRole(String userName) {
        Set<IUIUser> users = this.selectedRole.getUsers();
        for (IUIUser user : users) {
            if (!user.getName().equals(userName)) continue;
            return user;
        }
        return null;
    }

    private IUIUser getUserAtIndex(int index) {
        return (IUIUser)this.userList.get(index);
    }

    private int getIndexOfUser(IUIUser ru) {
        for (int i = 0; i < this.userList.size(); ++i) {
            IUIUser user = (IUIUser)this.userList.get(i);
            if (!ru.getName().equals(user.getName())) continue;
            return i;
        }
        return -1;
    }

    private IUIRole getRoleAtIndex(int index) {
        return this.roleList.get(index);
    }

    protected int getIndexOfRole(IUIRole rr) {
        for (int i = 0; i < this.roleList.size(); ++i) {
            IUIRole role = this.roleList.get(i);
            if (!rr.getName().equals(role.getName())) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexOfSystemRole(IUIRole rr) {
        for (int i = 0; i < this.systemRoleList.size(); ++i) {
            IUIRole role = this.systemRoleList.get(i);
            if (!rr.getName().equals(role.getName())) continue;
            return i;
        }
        return -1;
    }

    private void assignRoleToUser(IUIUser userInfo2, IUIRole role) {
        IUIEEUser userInfo = this.findEEUser(userInfo2);
        if (userInfo != null) {
            userInfo.addRole(role);
        }
    }

    private void unassignRoleFromUser(IUIUser user, IUIRole role) {
        IUIEEUser userInfo = this.findEEUser(user);
        if (userInfo != null) {
            userInfo.removeRole(role);
        }
    }

    private void assignUserToRole(IUIRole role, IUIUser user) {
        IUIRole roleInfo = this.findRole(role);
        if (roleInfo != null) {
            roleInfo.addUser(user);
        }
    }

    private void unassignUserFromRole(IUIRole role, IUIUser user) {
        IUIRole roleInfo = this.findRole(role);
        if (roleInfo != null) {
            roleInfo.removeUser(user);
        }
    }

    private IUIEEUser findEEUser(IUIUser userInfo) {
        for (IUIUser user : this.userList) {
            if (!user.getName().equals(userInfo.getName()) || !(user instanceof IUIEEUser)) continue;
            return (IUIEEUser)user;
        }
        return null;
    }

    private IUIRole findRole(IUIRole role) {
        for (IUIRole roleInfo : this.roleList) {
            if (!roleInfo.getName().equals(role.getName())) continue;
            return roleInfo;
        }
        return null;
    }
}

