/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IAclObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.ILockObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.controller.AbstractPermissionsController;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcl;
import org.pentaho.di.ui.repository.repositoryexplorer.AccessDeniedException;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.IBrowseController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDeck;

public class PermissionsController
extends AbstractPermissionsController
implements ContextChangeVetoer,
IUISupportController,
Serializable {
    private static final long serialVersionUID = -6151060931568671109L;
    private static final Class<?> PKG = IUIEEUser.class;
    private static final int NO_ACL = 0;
    private static final int ACL = 1;
    private XulDeck aclDeck;
    private XulCheckbox inheritParentPermissionCheckbox;
    private XulLabel fileFolderLabel;
    List<UIRepositoryObject> repoObject = new ArrayList<UIRepositoryObject>();
    private IBrowseController browseController;

    public List<UIRepositoryObject> getSelectedObjects() {
        return this.repoObject;
    }

    @Override
    public void init(Repository rep) throws ControllerInitializationException {
        try {
            super.init(rep);
            this.browseController = (IBrowseController)this.getXulDomContainer().getEventHandler("browseController");
            this.browseController.addContextChangeVetoer((ContextChangeVetoer)this);
            this.createBindings();
        }
        catch (Exception e) {
            throw new ControllerInitializationException((Throwable)e);
        }
    }

    @Override
    protected void createBindings() {
        block3: {
            super.createBindings();
            this.fileFolderLabel = (XulLabel)this.document.getElementById("file-folder-name");
            this.aclDeck = (XulDeck)this.document.getElementById("acl-deck");
            this.inheritParentPermissionCheckbox = (XulCheckbox)this.document.getElementById("inherit-from-parent-permission-checkbox");
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            BindingConvertor<List<UIRepositoryObject>, List<UIRepositoryObjectAcl>> securityBindingConverter = new BindingConvertor<List<UIRepositoryObject>, List<UIRepositoryObjectAcl>>(){

                public List<UIRepositoryObjectAcl> sourceToTarget(List<UIRepositoryObject> ro) {
                    block9: {
                        if (ro == null) {
                            return null;
                        }
                        if (ro.size() <= 0) {
                            return null;
                        }
                        PermissionsController.this.setSelectedRepositoryObject(ro);
                        if (!PermissionsController.this.hasManageAclAccess()) {
                            PermissionsController.this.applyAclButton.setDisabled(true);
                            PermissionsController.this.addAclButton.setDisabled(true);
                            PermissionsController.this.removeAclButton.setDisabled(true);
                            PermissionsController.this.inheritParentPermissionCheckbox.setDisabled(true);
                            PermissionsController.this.manageAclCheckbox.setDisabled(true);
                            PermissionsController.this.deleteCheckbox.setDisabled(true);
                            PermissionsController.this.writeCheckbox.setDisabled(true);
                            PermissionsController.this.readCheckbox.setDisabled(true);
                            PermissionsController.this.viewAclsModel.setHasManageAclAccess(false);
                        } else {
                            PermissionsController.this.applyAclButton.setDisabled(false);
                            PermissionsController.this.inheritParentPermissionCheckbox.setDisabled(false);
                            PermissionsController.this.viewAclsModel.setHasManageAclAccess(true);
                        }
                        PermissionsController.this.viewAclsModel.setRemoveEnabled(false);
                        List<UIRepositoryObjectAcl> selectedAclList = Collections.emptyList();
                        PermissionsController.this.viewAclsModel.setSelectedAclList(selectedAclList);
                        PermissionsController.this.permissionsCheckboxHandler.updateCheckboxes(EnumSet.noneOf(RepositoryFilePermission.class));
                        UIRepositoryObject repoObject = ro.get(0);
                        try {
                            if (!(repoObject instanceof IAclObject)) {
                                throw new IllegalStateException(BaseMessages.getString((Class)PKG, (String)"PermissionsController.NoAclSupport", (String[])new String[0]));
                            }
                            ((IAclObject)repoObject).getAcls(PermissionsController.this.viewAclsModel);
                            PermissionsController.this.fileFolderLabel.setValue(BaseMessages.getString((Class)PKG, (String)"AclTab.UserRolePermission", (String[])new String[]{repoObject.getName()}));
                            PermissionsController.this.bf.setBindingType(Binding.Type.ONE_WAY);
                            PermissionsController.this.bf.createBinding((Object)PermissionsController.this.viewAclsModel, "acls", (Object)PermissionsController.this.userRoleList, "elements", new BindingConvertor[0]);
                            PermissionsController.this.updateInheritFromParentPermission();
                        }
                        catch (AccessDeniedException ade) {
                            if (PermissionsController.this.mainController == null || !PermissionsController.this.mainController.handleLostRepository((Throwable)ade)) {
                                PermissionsController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                                PermissionsController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                                PermissionsController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"PermissionsController.UnableToGetAcls", (String[])new String[]{repoObject.getName(), ade.getLocalizedMessage()}));
                                PermissionsController.this.messageBox.open();
                            }
                        }
                        catch (Exception e) {
                            if (PermissionsController.this.mainController != null && PermissionsController.this.mainController.handleLostRepository((Throwable)e)) break block9;
                            PermissionsController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                            PermissionsController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            PermissionsController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"PermissionsController.UnableToGetAcls", (String[])new String[]{repoObject.getName(), e.getLocalizedMessage()}));
                            PermissionsController.this.messageBox.open();
                        }
                    }
                    PermissionsController.this.aclDeck.setSelectedIndex(1);
                    return PermissionsController.this.viewAclsModel.getAcls();
                }

                public List<UIRepositoryObject> targetToSource(List<UIRepositoryObjectAcl> elements) {
                    return null;
                }
            };
            this.securityBinding = this.bf.createBinding((Object)this.browseController, "repositoryObjects", (Object)this.userRoleList, "elements", new BindingConvertor[]{securityBindingConverter});
            this.securityBinding = this.bf.createBinding((Object)this.browseController, "repositoryDirectories", (Object)this.userRoleList, "elements", new BindingConvertor[]{securityBindingConverter});
            this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
            this.bf.createBinding((Object)this.viewAclsModel, "entriesInheriting", (Object)this.inheritParentPermissionCheckbox, "checked", new BindingConvertor[0]);
            this.aclDeck.setSelectedIndex(0);
            try {
                if (this.securityBinding != null) {
                    this.securityBinding.fireSourceChanged();
                }
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public void setSelectedRepositoryObject(List<UIRepositoryObject> roList) {
        if (roList != null) {
            this.repoObject.clear();
            this.repoObject.addAll(roList);
        }
    }

    public String getName() {
        return "permissionsController";
    }

    public void apply() {
        List<UIRepositoryObject> roList = this.getSelectedObjects();
        this.applyOnObjectOnly(roList, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyOnObjectOnly(List<UIRepositoryObject> roList, boolean hideDialog) {
        try {
            if (roList.get(0) instanceof UIRepositoryDirectory) {
                UIRepositoryDirectory rd = (UIRepositoryDirectory)roList.get(0);
                if (!(rd instanceof IAclObject)) throw new IllegalStateException(BaseMessages.getString(PKG, (String)"PermissionsController.NoAclSupport", (String[])new String[0]));
                ((IAclObject)rd).setAcls(this.viewAclsModel);
            } else {
                UIRepositoryContent rc = (UIRepositoryContent)roList.get(0);
                if (rc instanceof ILockObject && ((ILockObject)rc).isLocked()) {
                    this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"PermissionsController.LockedObjectWarning", (String[])new String[0]));
                    this.messageBox.open();
                    this.viewAclsModel.setModelDirty(false);
                    return;
                }
                if (!(rc instanceof IAclObject)) throw new IllegalStateException(BaseMessages.getString(PKG, (String)"PermissionsController.NoAclSupport", (String[])new String[0]));
                ((IAclObject)rc).setAcls(this.viewAclsModel);
            }
            this.viewAclsModel.setModelDirty(false);
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"PermissionsController.PermissionAppliedSuccessfully", (String[])new String[0]));
            this.messageBox.open();
            return;
        }
        catch (AccessDeniedException ade) {
            if (this.mainController != null && this.mainController.handleLostRepository((Throwable)ade)) return;
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(ade.getLocalizedMessage());
            this.messageBox.open();
            return;
        }
        catch (KettleException kex) {
            if (this.mainController != null && this.mainController.handleLostRepository((Throwable)kex)) return;
            this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(kex.getLocalizedMessage());
            this.messageBox.open();
        }
    }

    public void applyAcl() throws Exception {
        List<UIRepositoryObject> roList = this.getSelectedObjects();
        this.applyOnObjectOnly(roList, true);
    }

    public void updateInheritFromParentPermission() throws AccessDeniedException {
        this.viewAclsModel.setEntriesInheriting(this.inheritParentPermissionCheckbox.isChecked());
        if (this.inheritParentPermissionCheckbox.isChecked()) {
            this.addAclButton.setDisabled(true);
            UIRepositoryObject ro = this.repoObject.get(0);
            if (ro instanceof IAclObject) {
                ((IAclObject)ro).clearAcl();
                ((IAclObject)ro).getAcls(this.viewAclsModel, true);
            }
            this.permissionsCheckboxHandler.updateCheckboxes(EnumSet.noneOf(RepositoryFilePermission.class));
        } else {
            this.addAclButton.setDisabled(!this.hasManageAclAccess());
            this.permissionsCheckboxHandler.processCheckboxes();
        }
    }

    @Override
    protected void updateCheckboxes(UIRepositoryObjectAcl acl) {
        this.permissionsCheckboxHandler.updateCheckboxes(!this.inheritParentPermissionCheckbox.isChecked() && this.hasManageAclAccess(), acl.getPermissionSet());
    }
}

