/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IAclObject;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.controller.AbstractPermissionsController;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIRepositoryObjectAcl;
import org.pentaho.di.ui.repository.repositoryexplorer.AccessDeniedException;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.ConnectionsController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIDatabaseConnection;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulLabel;

public class ConnectionPermissionsController
extends AbstractPermissionsController
implements ContextChangeVetoer,
IUISupportController,
Serializable {
    private static final long serialVersionUID = -8922989722897392836L;
    private static final Class<?> PKG = IUIEEUser.class;
    private ConnectionsController connectionsController;
    private XulLabel connNameLabel;
    private List<UIDatabaseConnection> selectedDbConns = new ArrayList<UIDatabaseConnection>();

    public String getName() {
        return "connectionPermissionsController";
    }

    @Override
    public void init(Repository rep) throws ControllerInitializationException {
        try {
            super.init(rep);
            this.connectionsController = (ConnectionsController)this.getXulDomContainer().getEventHandler("connectionsController");
            this.connectionsController.addContextChangeVetoer((ContextChangeVetoer)this);
            this.createBindings();
        }
        catch (Exception e) {
            throw new ControllerInitializationException((Throwable)e);
        }
    }

    @Override
    protected String getXulPrefix() {
        return "conn-";
    }

    @Override
    protected void createBindings() {
        block3: {
            super.createBindings();
            this.connNameLabel = (XulLabel)this.document.getElementById("conn-name");
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            BindingConvertor<List<UIDatabaseConnection>, List<UIRepositoryObjectAcl>> securityBindingConverter = new BindingConvertor<List<UIDatabaseConnection>, List<UIRepositoryObjectAcl>>(){

                public List<UIRepositoryObjectAcl> sourceToTarget(List<UIDatabaseConnection> ro) {
                    block10: {
                        if (ro == null) {
                            return null;
                        }
                        if (ro.size() <= 0) {
                            return null;
                        }
                        ConnectionPermissionsController.this.setSelectedDatabaseConnections(ro);
                        if (!ConnectionPermissionsController.this.hasManageAclAccess()) {
                            ConnectionPermissionsController.this.applyAclButton.setDisabled(true);
                            ConnectionPermissionsController.this.addAclButton.setDisabled(true);
                            ConnectionPermissionsController.this.removeAclButton.setDisabled(true);
                            ConnectionPermissionsController.this.manageAclCheckbox.setDisabled(true);
                            ConnectionPermissionsController.this.deleteCheckbox.setDisabled(true);
                            ConnectionPermissionsController.this.writeCheckbox.setDisabled(true);
                            ConnectionPermissionsController.this.readCheckbox.setDisabled(true);
                            ConnectionPermissionsController.this.viewAclsModel.setHasManageAclAccess(false);
                        } else {
                            ConnectionPermissionsController.this.applyAclButton.setDisabled(false);
                            ConnectionPermissionsController.this.addAclButton.setDisabled(false);
                            ConnectionPermissionsController.this.viewAclsModel.setHasManageAclAccess(true);
                        }
                        ConnectionPermissionsController.this.viewAclsModel.setRemoveEnabled(false);
                        List<UIRepositoryObjectAcl> selectedAclList = Collections.emptyList();
                        ConnectionPermissionsController.this.viewAclsModel.setSelectedAclList(selectedAclList);
                        ConnectionPermissionsController.this.permissionsCheckboxHandler.setAllChecked(false);
                        UIDatabaseConnection dbconnObject = ro.get(0);
                        try {
                            if (dbconnObject instanceof IAclObject) {
                                IAclObject aclObj = (IAclObject)dbconnObject;
                                aclObj.getAcls(ConnectionPermissionsController.this.viewAclsModel);
                                if (ConnectionPermissionsController.this.viewAclsModel.isEntriesInheriting()) {
                                    ConnectionPermissionsController.this.viewAclsModel.setEntriesInheriting(false);
                                    aclObj.setAcls(ConnectionPermissionsController.this.viewAclsModel);
                                    ConnectionPermissionsController.this.viewAclsModel.setModelDirty(false);
                                }
                            } else {
                                throw new IllegalStateException(BaseMessages.getString((Class)PKG, (String)"PermissionsController.NoAclSupport", (String[])new String[0]));
                            }
                            ConnectionPermissionsController.this.connNameLabel.setValue(BaseMessages.getString((Class)PKG, (String)"AclTab.ConnectionPermission", (String[])new String[]{dbconnObject.getDisplayName()}));
                            ConnectionPermissionsController.this.bf.setBindingType(Binding.Type.ONE_WAY);
                            ConnectionPermissionsController.this.bf.createBinding((Object)ConnectionPermissionsController.this.viewAclsModel, "acls", (Object)ConnectionPermissionsController.this.userRoleList, "elements", new BindingConvertor[0]);
                        }
                        catch (AccessDeniedException ade) {
                            ConnectionPermissionsController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                            ConnectionPermissionsController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            ConnectionPermissionsController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"PermissionsController.UnableToGetAcls", (String[])new String[]{dbconnObject.getName(), ade.getLocalizedMessage()}));
                            ConnectionPermissionsController.this.messageBox.open();
                        }
                        catch (Exception e) {
                            if (ConnectionPermissionsController.this.mainController != null && ConnectionPermissionsController.this.mainController.handleLostRepository((Throwable)e)) break block10;
                            ConnectionPermissionsController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                            ConnectionPermissionsController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            ConnectionPermissionsController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"PermissionsController.UnableToGetAcls", (String[])new String[]{dbconnObject.getName(), e.getLocalizedMessage()}));
                            ConnectionPermissionsController.this.messageBox.open();
                        }
                    }
                    return ConnectionPermissionsController.this.viewAclsModel.getAcls();
                }

                public List<UIDatabaseConnection> targetToSource(List<UIRepositoryObjectAcl> elements) {
                    return null;
                }
            };
            this.securityBinding = this.bf.createBinding((Object)this.connectionsController, "repositoryConnections", (Object)this.userRoleList, "elements", new BindingConvertor[]{securityBindingConverter});
            try {
                if (this.securityBinding != null) {
                    this.securityBinding.fireSourceChanged();
                }
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public void setSelectedDatabaseConnections(List<UIDatabaseConnection> dbconnList) {
        if (dbconnList != null) {
            this.selectedDbConns.clear();
            this.selectedDbConns.addAll(dbconnList);
        }
    }

    public List<UIDatabaseConnection> getSelectedObjects() {
        return this.selectedDbConns;
    }

    public void apply() {
        List<UIDatabaseConnection> roList = this.getSelectedObjects();
        this.applyOnObjectOnly(roList, false);
    }

    private void applyOnObjectOnly(List<UIDatabaseConnection> roList, boolean hideDialog) {
        block3: {
            try {
                UIDatabaseConnection rd = roList.get(0);
                if (!(rd instanceof IAclObject)) {
                    throw new IllegalStateException(BaseMessages.getString(PKG, (String)"PermissionsController.NoAclSupport", (String[])new String[0]));
                }
                ((IAclObject)rd).setAcls(this.viewAclsModel);
                this.viewAclsModel.setModelDirty(false);
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"PermissionsController.PermissionAppliedSuccessfully", (String[])new String[0]));
                this.messageBox.open();
            }
            catch (AccessDeniedException ade) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)ade)) break block3;
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(ade.getLocalizedMessage());
                this.messageBox.open();
            }
        }
    }

    public void applyAcl() throws Exception {
        List<UIDatabaseConnection> roList = this.getSelectedObjects();
        this.applyOnObjectOnly(roList, true);
    }
}

