/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.PurRepositorySecurityManager;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.model.AbsRoleInfo;
import org.pentaho.di.repository.pur.model.IAbsRole;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityManager;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.pentaho.platform.security.policy.rolebased.ws.IRoleAuthorizationPolicyRoleBindingDaoWebService;

public class AbsSecurityManager
extends PurRepositorySecurityManager
implements IAbsSecurityManager,
Serializable {
    private static final long serialVersionUID = -7472721270945456826L;
    private IRoleAuthorizationPolicyRoleBindingDaoWebService authorizationPolicyRoleBindingService = null;
    private RoleBindingStruct roleBindingStruct = null;

    public AbsSecurityManager(PurRepository repository, PurRepositoryMeta repositoryMeta, IUser userInfo, ServiceManager serviceManager) {
        super(repository, repositoryMeta, userInfo, serviceManager);
        try {
            this.authorizationPolicyRoleBindingService = serviceManager.createService(userInfo.getLogin(), userInfo.getPassword(), IRoleAuthorizationPolicyRoleBindingDaoWebService.class);
            if (this.authorizationPolicyRoleBindingService == null) {
                AbsSecurityManager.getLogger().error((Object)BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0001_UNABLE_TO_INITIALIZE_ROLE_BINDING_WEBSVC", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            AbsSecurityManager.getLogger().error((Object)BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0001_UNABLE_TO_INITIALIZE_ROLE_BINDING_WEBSVC", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void initialize(String locale) throws KettleException {
        if (this.authorizationPolicyRoleBindingService != null) {
            try {
                this.roleBindingStruct = this.authorizationPolicyRoleBindingService.getRoleBindingStruct(locale);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0002_UNABLE_TO_GET_LOGICAL_ROLES", (String[])new String[0]), (Throwable)e);
            }
        } else {
            throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0005_INSUFFICIENT_PRIVELEGES", (String[])new String[0]));
        }
    }

    @Override
    public IRole getRole(String name) throws KettleException {
        List<String> logicalRoles;
        IRole role = super.getRole(name);
        if (role instanceof IAbsRole && (logicalRoles = this.getLogicalRoles(role.getName())) != null && logicalRoles.size() > 0) {
            ((IAbsRole)role).setLogicalRoles(logicalRoles);
        }
        return role;
    }

    @Override
    public List<IRole> getRoles() throws KettleException {
        List<IRole> roles = super.getRoles();
        for (IRole role : roles) {
            List<String> logicalRoles;
            if (!(role instanceof IAbsRole) || (logicalRoles = this.getLogicalRoles(role.getName())) == null || logicalRoles.size() <= 0) continue;
            ((IAbsRole)role).setLogicalRoles(logicalRoles);
        }
        return roles;
    }

    @Override
    public IRole constructRole() throws KettleException {
        return new AbsRoleInfo();
    }

    public List<String> getLocalizedLogicalRoles(String runtimeRole, String locale) throws KettleException {
        if (this.authorizationPolicyRoleBindingService != null) {
            ArrayList<String> localizedLogicalRoles = new ArrayList<String>();
            if (this.roleBindingStruct != null && this.roleBindingStruct.logicalRoleNameMap != null) {
                List<String> logicalRoles = this.getLogicalRoles(runtimeRole);
                for (String logicalRole : logicalRoles) {
                    localizedLogicalRoles.add((String)this.roleBindingStruct.logicalRoleNameMap.get(logicalRole));
                }
            } else {
                throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0003_UNABLE_TO_ACCESS_ROLE_BINDING_WEBSVC", (String[])new String[0]));
            }
            return localizedLogicalRoles;
        }
        throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0005_INSUFFICIENT_PRIVELEGES", (String[])new String[0]));
    }

    @Override
    public List<String> getLogicalRoles(String runtimeRole) throws KettleException {
        if (this.authorizationPolicyRoleBindingService != null) {
            if (this.roleBindingStruct != null && this.roleBindingStruct.bindingMap != null && this.roleBindingStruct.bindingMap.containsKey(runtimeRole)) {
                return (List)this.roleBindingStruct.bindingMap.get(runtimeRole);
            }
            return null;
        }
        throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0005_INSUFFICIENT_PRIVELEGES", (String[])new String[0]));
    }

    @Override
    public void setLogicalRoles(String rolename, List<String> logicalRoles) throws KettleException {
        if (this.authorizationPolicyRoleBindingService != null) {
            try {
                this.authorizationPolicyRoleBindingService.setRoleBindings(rolename, logicalRoles);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0004_UNABLE_TO_APPLY_LOGICAL_ROLES_TO_RUNTIME_ROLE", (String[])new String[]{rolename}), (Throwable)e);
            }
        } else {
            throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0005_INSUFFICIENT_PRIVELEGES", (String[])new String[0]));
        }
    }

    @Override
    public Map<String, String> getAllLogicalRoles(String locale) throws KettleException {
        if (this.authorizationPolicyRoleBindingService != null) {
            return this.roleBindingStruct.logicalRoleNameMap;
        }
        throw new KettleException(BaseMessages.getString(AbsSecurityManager.class, (String)"AbsSecurityManager.ERROR_0005_INSUFFICIENT_PRIVELEGES", (String[])new String[0]));
    }
}

