/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.PurgeDeletionException;
import com.pentaho.di.purge.PurgeUtilityLogger;
import com.pentaho.di.purge.PurgeUtilitySpecification;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.repository.pur.services.IPurgeService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;

public class UnifiedRepositoryPurgeService
implements IPurgeService {
    private final IUnifiedRepository unifiedRepository;
    public static DefaultUnifiedRepositoryWebService repoWs;
    private static String[] sharedObjectFolders;

    public UnifiedRepositoryPurgeService(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    @Override
    public void deleteVersionsBeforeDate(RepositoryElementInterface element, Date beforeDate) throws KettleException {
        try {
            String fileId = element.getObjectId().getId();
            this.deleteVersionsBeforeDate((Serializable)((Object)fileId), beforeDate);
        }
        catch (Exception e) {
            this.processDeleteException(e);
        }
    }

    @Override
    public void deleteVersionsBeforeDate(Serializable fileId, Date beforeDate) {
        List versionList = this.unifiedRepository.getVersionSummaries(fileId);
        int listSize = versionList.size();
        int removedCount = 0;
        for (VersionSummary versionSummary : versionList) {
            if (listSize - removedCount <= 1) break;
            if (!versionSummary.getDate().before(beforeDate)) continue;
            Serializable versionId = versionSummary.getId();
            this.getLogger().debug("removing version " + versionId.toString());
            this.unifiedRepository.deleteFileAtVersion(fileId, versionId);
            ++removedCount;
        }
    }

    @Override
    public void deleteAllVersions(RepositoryElementInterface element) throws KettleException {
        String fileId = element.getObjectId().getId();
        this.deleteAllVersions((Serializable)((Object)fileId));
    }

    @Override
    public void deleteAllVersions(Serializable fileId) {
        this.keepNumberOfVersions(fileId, 1);
    }

    @Override
    public void deleteVersion(RepositoryElementInterface element, String versionId) throws KettleException {
        String fileId = element.getObjectId().getId();
        this.deleteVersion((Serializable)((Object)fileId), (Serializable)((Object)versionId));
    }

    @Override
    public void deleteVersion(Serializable fileId, Serializable versionId) {
        this.unifiedRepository.deleteFileAtVersion(fileId, versionId);
    }

    @Override
    public void keepNumberOfVersions(RepositoryElementInterface element, int versionCount) throws KettleException {
        String fileId = element.getObjectId().getId();
        this.keepNumberOfVersions((Serializable)((Object)fileId), versionCount);
    }

    @Override
    public void keepNumberOfVersions(Serializable fileId, int versionCount) {
        List versionList = this.unifiedRepository.getVersionSummaries(fileId);
        int i = 0;
        int listSize = versionList.size();
        if (listSize > versionCount) {
            this.getLogger().info("version count: removing versions");
        }
        for (VersionSummary versionSummary : versionList) {
            if (i >= listSize - versionCount) break;
            Serializable versionId = versionSummary.getId();
            this.getLogger().debug("removing version " + versionId.toString());
            this.unifiedRepository.deleteFileAtVersion(fileId, versionId);
            ++i;
        }
    }

    private void processDeleteException(Throwable e) throws KettleException {
        throw new KettleException("Unable to complete revision deletion", e);
    }

    @Override
    public void doDeleteRevisions(PurgeUtilitySpecification purgeSpecification) throws PurgeDeletionException {
        if (purgeSpecification != null) {
            this.getLogger().setCurrentFilePath(purgeSpecification.getPath());
            this.logConfiguration(purgeSpecification);
            if (purgeSpecification.getPath() != null && !purgeSpecification.getPath().isEmpty()) {
                this.processRevisionDeletion(purgeSpecification);
            }
            if (purgeSpecification.isSharedObjects()) {
                if (purgeSpecification.isPurgeFiles()) {
                    for (String sharedObjectpath : sharedObjectFolders) {
                        purgeSpecification.fileFilter = "*";
                        purgeSpecification.setPath(sharedObjectpath);
                        this.processRevisionDeletion(purgeSpecification);
                    }
                } else {
                    throw new PurgeDeletionException("Must purge files before shared objects");
                }
            }
        }
    }

    private void processRevisionDeletion(PurgeUtilitySpecification purgeSpecification) throws PurgeDeletionException {
        RepositoryRequest repositoryRequest = new RepositoryRequest(purgeSpecification.getPath(), Boolean.valueOf(true), Integer.valueOf(-1), purgeSpecification.getFileFilter());
        repositoryRequest.setTypes(RepositoryRequest.FILES_TYPE_FILTER.FILES_FOLDERS);
        repositoryRequest.setIncludeMemberSet(new HashSet<String>(Arrays.asList("name", "id", "folder", "path", "versioned", "versionId", "locked")));
        this.getLogger().debug("Creating file list");
        RepositoryFileTreeDto tree = UnifiedRepositoryPurgeService.getRepoWs().getTreeFromRequest(repositoryRequest);
        this.processPurgeForTree(tree, purgeSpecification);
    }

    private void processPurgeForTree(RepositoryFileTreeDto tree, PurgeUtilitySpecification purgeSpecification) {
        for (RepositoryFileTreeDto child : tree.getChildren()) {
            try {
                if (!child.getChildren().isEmpty()) {
                    this.processPurgeForTree(child, purgeSpecification);
                }
                RepositoryFileDto file = child.getFile();
                this.getLogger().setCurrentFilePath(file.getPath());
                if (!file.isVersioned()) continue;
                if (purgeSpecification.isPurgeFiles()) {
                    this.getLogger().info("Purge File");
                    this.keepNumberOfVersions((Serializable)((Object)file.getId()), 1);
                    UnifiedRepositoryPurgeService.getRepoWs().deleteFileWithPermanentFlag(file.getId(), true, "purge utility");
                    continue;
                }
                if (purgeSpecification.isPurgeRevisions()) {
                    this.getLogger().info("Purging Revisions");
                    this.deleteAllVersions((Serializable)((Object)file.getId()));
                    continue;
                }
                if (purgeSpecification.getBeforeDate() != null) {
                    this.getLogger().info("Checking/purging by Revision date");
                    this.deleteVersionsBeforeDate((Serializable)((Object)file.getId()), purgeSpecification.getBeforeDate());
                }
                if (purgeSpecification.getVersionCount() < 0) continue;
                this.getLogger().info("Checking/purging by number of Revisions");
                this.keepNumberOfVersions((Serializable)((Object)file.getId()), purgeSpecification.getVersionCount());
            }
            catch (Exception e) {
                this.getLogger().error(e);
            }
        }
    }

    public static DefaultUnifiedRepositoryWebService getRepoWs() {
        if (repoWs == null) {
            repoWs = new DefaultUnifiedRepositoryWebService();
        }
        return repoWs;
    }

    private PurgeUtilityLogger getLogger() {
        return PurgeUtilityLogger.getPurgeUtilityLogger();
    }

    private void logConfiguration(PurgeUtilitySpecification purgeSpecification) {
        if (purgeSpecification.getFileFilter() != null && purgeSpecification.getFileFilter().isEmpty()) {
            this.getLogger().info("Configure File Filter" + purgeSpecification.getFileFilter());
        }
        if (purgeSpecification.isPurgeFiles()) {
            this.getLogger().info("Configure PurgeAllFiles: true");
        }
        if (purgeSpecification.isPurgeRevisions()) {
            this.getLogger().info("Configure PurgeAllRevisions: true");
        }
        if (purgeSpecification.isSharedObjects()) {
            this.getLogger().info("Configure ShareObjects: true");
        }
        if (purgeSpecification.getBeforeDate() != null) {
            this.getLogger().info("Configure purgeBeforeDate: " + purgeSpecification.getBeforeDate().toString());
        }
        if (purgeSpecification.getVersionCount() != -1) {
            this.getLogger().info("Configure versionCount: " + purgeSpecification.getVersionCount());
        }
    }

    static {
        sharedObjectFolders = new String[]{"/etc/pdi/databases", "/etc/pdi/clusterSchemas", "/etc/pdi/partitionSchemas", "/etc/pdi/slaveServers"};
    }
}

