/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import java.util.Date;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.DateConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TypedPropertyReadHandler
extends StringReadHandler {
    private Object value;
    private String name;
    private String type;
    private Class typeClass;

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.name = attrs.getValue(this.getUri(), "name");
        this.type = attrs.getValue(this.getUri(), "type");
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        String result = this.getResult();
        if (Boolean.class.getName().equals(this.type)) {
            if (!StringUtils.isEmpty((String)result)) {
                this.value = Boolean.valueOf(result);
            }
            this.typeClass = Boolean.class;
        } else if (Integer.class.getName().equals(this.type)) {
            if (!StringUtils.isEmpty((String)result)) {
                this.value = new Integer(result);
            }
            this.typeClass = Integer.class;
        } else if (Double.class.getName().equals(this.type)) {
            if (!StringUtils.isEmpty((String)result)) {
                this.value = new Double(result);
            }
            this.typeClass = Double.class;
        } else if (Date.class.getName().equals(this.type)) {
            if (!StringUtils.isEmpty((String)result)) {
                this.value = DateConverter.getObject(result);
            }
            this.typeClass = Date.class;
        } else {
            this.value = result;
            this.typeClass = String.class;
        }
    }

    public Class getType() {
        return this.typeClass;
    }

    public String getName() {
        return this.name;
    }

    public Object getObject() {
        return this.value;
    }
}

