/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import java.beans.IntrospectionException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.FormulaFunction;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.ReportDesignerParserUtil;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.DesignerExpressionPropertyReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportFunctionReadHandler
extends AbstractXmlReadHandler {
    private Expression expression;
    private BeanUtility beanUtility;

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String type = attrs.getValue(this.getUri(), "type");
        if (!type.endsWith("_DesignerWrapper")) {
            throw new ParseException("Magic-Token not found");
        }
        String realType = CompatibilityMapperUtil.mapClassName((String)type.substring(0, type.length() - "_DesignerWrapper".length()));
        Object expression = ObjectUtilities.loadAndInstantiate((String)realType, ReportFunctionReadHandler.class, Expression.class);
        if (expression == null) {
            throw new ParseException("Specified expression does not exist");
        }
        try {
            this.expression = (Expression)expression;
            this.beanUtility = new BeanUtility(expression);
        }
        catch (IntrospectionException e) {
            throw new ParseException("Specified expression cannot be beaned");
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("padding".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("property".equals(tagName)) {
            return new DesignerExpressionPropertyReadHandler(this.beanUtility, this.expression.getName());
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        if (this.expression instanceof FormulaExpression) {
            FormulaExpression formulaExpression = (FormulaExpression)this.expression;
            formulaExpression.setFormula(ReportDesignerParserUtil.normalizeFormula(formulaExpression.getFormula()));
        } else if (this.expression instanceof FormulaFunction) {
            FormulaFunction formulaFunction = (FormulaFunction)this.expression;
            formulaFunction.setFormula(ReportDesignerParserUtil.normalizeFormula(formulaFunction.getFormula()));
            formulaFunction.setInitial(ReportDesignerParserUtil.normalizeFormula(formulaFunction.getInitial()));
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Object getObject() throws SAXException {
        return this.expression;
    }
}

