/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JdbcDataSetReadHandler
extends AbstractXmlReadHandler {
    private String userName;
    private String password;
    private String driverClass;
    private String sqlQuery;
    private String connectionString;
    private SQLReportDataFactory dataFactory;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.userName = attrs.getValue(this.getUri(), "userName");
        this.password = attrs.getValue(this.getUri(), "password");
        this.driverClass = attrs.getValue(this.getUri(), "driverClass");
        this.sqlQuery = attrs.getValue(this.getUri(), "sqlQuery");
        this.connectionString = attrs.getValue(this.getUri(), "connectionString");
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        return new IgnoreAnyChildReadHandler();
    }

    protected void doneParsing() throws SAXException {
        DriverConnectionProvider connectionProvider = new DriverConnectionProvider();
        connectionProvider.setDriver(this.driverClass);
        connectionProvider.setUrl(this.connectionString);
        connectionProvider.setProperty("user", this.userName);
        connectionProvider.setProperty("password", this.password);
        this.dataFactory = new SQLReportDataFactory((ConnectionProvider)connectionProvider);
        this.dataFactory.setQuery("default", this.sqlQuery, null, null);
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }
}

