/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.logaggregation.PerContainerLogFileInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LogCLIHelpers
implements Configurable {
    public static final String PER_LOG_FILE_INFO_PATTERN = "%30s\t%30s\t%30s\t%30s" + System.getProperty("line.separator");
    public static final String CONTAINER_ON_NODE_PATTERN = "Container: %s on %s";
    private Configuration conf;

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainersLogs(String appId, String containerId, String nodeId, String jobOwner) throws IOException {
        ContainerLogsRequest options = new ContainerLogsRequest();
        options.setAppId(ConverterUtils.toApplicationId(appId));
        options.setContainerId(containerId);
        options.setNodeId(nodeId);
        options.setAppOwner(jobOwner);
        HashSet<String> logs = new HashSet<String>();
        options.setLogTypes(logs);
        options.setBytes(Long.MAX_VALUE);
        return this.dumpAContainerLogsForLogType(options, false);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static String getOwnerForAppIdOrNull(ApplicationId appId, String bestGuess, Configuration conf) throws IOException {
        Path remoteRootLogDir = new Path(conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(conf);
        Path fullPath = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, bestGuess, suffix);
        FileContext fc = FileContext.getFileContext((URI)remoteRootLogDir.toUri(), (Configuration)conf);
        String pathAccess = fullPath.toString();
        try {
            if (fc.util().exists(fullPath)) {
                return bestGuess;
            }
            Path toMatch = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, "*", suffix);
            pathAccess = toMatch.toString();
            FileStatus[] matching = fc.util().globStatus(toMatch);
            if (matching == null || matching.length != 1) {
                return null;
            }
            Path parent = matching[0].getPath().getParent();
            if (suffix != null && !StringUtils.isEmpty((String)suffix)) {
                parent = parent.getParent();
            }
            return parent.getName();
        }
        catch (AccessDeniedException | AccessControlException ex) {
            LogCLIHelpers.logDirNoAccessPermission(pathAccess, bestGuess, ex.getMessage());
            return null;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainerLogsForLogType(ContainerLogsRequest options) throws IOException {
        return this.dumpAContainerLogsForLogType(options, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainerLogsForLogType(ContainerLogsRequest options, boolean outputFailure) throws IOException {
        ApplicationId applicationId = options.getAppId();
        String jobOwner = options.getAppOwner();
        String nodeId = options.getNodeId();
        String containerId = options.getContainerId();
        String localDir = options.getOutputLocalDir();
        ArrayList<String> logType = new ArrayList<String>(options.getLogTypes());
        RemoteIterator<FileStatus> nodeFiles = this.getRemoteNodeFileDir(applicationId, jobOwner);
        if (nodeFiles == null) {
            return -1;
        }
        boolean foundContainerLogs = false;
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            String fileName = thisNodeFile.getPath().getName();
            if (!fileName.contains(LogAggregationUtils.getNodeString(nodeId)) || fileName.endsWith(".tmp")) continue;
            AggregatedLogFormat.LogReader reader = null;
            PrintStream out = this.createPrintStream(localDir, fileName, containerId);
            try {
                reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());
                if (this.getContainerLogsStream(containerId, reader) == null) continue;
                String containerString = String.format(CONTAINER_ON_NODE_PATTERN, containerId, thisNodeFile.getPath().getName());
                out.println(containerString);
                out.println("LogAggregationType: AGGREGATED");
                out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
                reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());
                if (logType == null || logType.isEmpty()) {
                    if (this.dumpAContainerLogs(containerId, reader, out, thisNodeFile.getModificationTime(), options.getBytes()) <= -1) continue;
                    foundContainerLogs = true;
                    continue;
                }
                if (this.dumpAContainerLogsForALogType(containerId, reader, out, thisNodeFile.getModificationTime(), logType, options.getBytes()) <= -1) continue;
                foundContainerLogs = true;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                this.closePrintStream(out);
            }
        }
        if (!foundContainerLogs) {
            if (outputFailure) {
                LogCLIHelpers.containerLogNotFound(containerId);
            }
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int dumpAContainerLogsForLogTypeWithoutNodeId(ContainerLogsRequest options) throws IOException {
        ApplicationId applicationId = options.getAppId();
        String jobOwner = options.getAppOwner();
        String containerId = options.getContainerId();
        String localDir = options.getOutputLocalDir();
        ArrayList<String> logType = new ArrayList<String>(options.getLogTypes());
        RemoteIterator<FileStatus> nodeFiles = this.getRemoteNodeFileDir(applicationId, jobOwner);
        if (nodeFiles == null) {
            return -1;
        }
        boolean foundContainerLogs = false;
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            if (thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            AggregatedLogFormat.LogReader reader = null;
            PrintStream out = System.out;
            try {
                reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());
                if (this.getContainerLogsStream(containerId, reader) == null) continue;
                reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());
                out = this.createPrintStream(localDir, thisNodeFile.getPath().getName(), containerId);
                String containerString = String.format(CONTAINER_ON_NODE_PATTERN, containerId, thisNodeFile.getPath().getName());
                out.println(containerString);
                out.println("LogAggregationType: AGGREGATED");
                out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
                if (logType == null || logType.isEmpty()) {
                    if (this.dumpAContainerLogs(containerId, reader, out, thisNodeFile.getModificationTime(), options.getBytes()) <= -1) continue;
                    foundContainerLogs = true;
                    continue;
                }
                if (this.dumpAContainerLogsForALogType(containerId, reader, out, thisNodeFile.getModificationTime(), logType, options.getBytes()) <= -1) continue;
                foundContainerLogs = true;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                this.closePrintStream(out);
            }
        }
        if (!foundContainerLogs) {
            LogCLIHelpers.containerLogNotFound(containerId);
            return -1;
        }
        return 0;
    }

    @InterfaceAudience.Private
    public int dumpAContainerLogs(String containerIdStr, AggregatedLogFormat.LogReader reader, PrintStream out, long logUploadedTime, long bytes) throws IOException {
        DataInputStream valueStream = this.getContainerLogsStream(containerIdStr, reader);
        if (valueStream == null) {
            return -1;
        }
        boolean foundContainerLogs = false;
        try {
            while (true) {
                AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out, logUploadedTime, bytes);
                foundContainerLogs = true;
            }
        }
        catch (EOFException eof) {
            if (foundContainerLogs) {
                return 0;
            }
            return -1;
        }
    }

    private DataInputStream getContainerLogsStream(String containerIdStr, AggregatedLogFormat.LogReader reader) throws IOException {
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        DataInputStream valueStream = reader.next(key);
        while (valueStream != null && !key.toString().equals(containerIdStr)) {
            key = new AggregatedLogFormat.LogKey();
            valueStream = reader.next(key);
        }
        return valueStream;
    }

    @InterfaceAudience.Private
    public int dumpAContainerLogsForALogType(String containerIdStr, AggregatedLogFormat.LogReader reader, PrintStream out, long logUploadedTime, List<String> logType, long bytes) throws IOException {
        DataInputStream valueStream = this.getContainerLogsStream(containerIdStr, reader);
        if (valueStream == null) {
            return -1;
        }
        boolean foundContainerLogs = false;
        try {
            while (true) {
                int result;
                if ((result = AggregatedLogFormat.LogReader.readContainerLogsForALogType(valueStream, out, logUploadedTime, logType, bytes)) != 0) {
                    continue;
                }
                foundContainerLogs = true;
            }
        }
        catch (EOFException eof) {
            if (foundContainerLogs) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int dumpAllContainersLogs(ContainerLogsRequest options) throws IOException {
        ApplicationId appId = options.getAppId();
        String appOwner = options.getAppOwner();
        String localDir = options.getOutputLocalDir();
        ArrayList<String> logTypes = new ArrayList<String>(options.getLogTypes());
        RemoteIterator<FileStatus> nodeFiles = this.getRemoteNodeFileDir(appId, appOwner);
        if (nodeFiles == null) {
            return -1;
        }
        boolean foundAnyLogs = false;
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            if (thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    PrintStream out = this.createPrintStream(localDir, thisNodeFile.getPath().getName(), key.toString());
                    try {
                        String containerString = String.format(CONTAINER_ON_NODE_PATTERN, key, thisNodeFile.getPath().getName());
                        out.println(containerString);
                        out.println("LogAggregationType: AGGREGATED");
                        out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
                        try {
                            while (true) {
                                if (logTypes == null || logTypes.isEmpty()) {
                                    AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out, thisNodeFile.getModificationTime(), options.getBytes());
                                    foundAnyLogs = true;
                                    continue;
                                }
                                int result = AggregatedLogFormat.LogReader.readContainerLogsForALogType(valueStream, out, thisNodeFile.getModificationTime(), logTypes, options.getBytes());
                                if (result != 0) continue;
                                foundAnyLogs = true;
                            }
                        }
                        catch (EOFException eof) {
                            this.closePrintStream(out);
                        }
                    }
                    catch (Throwable throwable) {
                        this.closePrintStream(out);
                        throw throwable;
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
        }
        if (!foundAnyLogs) {
            LogCLIHelpers.emptyLogDir(LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, appOwner).toString());
            return -1;
        }
        return 0;
    }

    @InterfaceAudience.Private
    public int printAContainerLogMetadata(ContainerLogsRequest options, PrintStream out, PrintStream err) throws IOException {
        List<ContainerLogMeta> containersLogMeta;
        ApplicationId appId = options.getAppId();
        String appOwner = options.getAppOwner();
        String nodeId = options.getNodeId();
        String containerIdStr = options.getContainerId();
        try {
            containersLogMeta = LogToolUtils.getContainerLogMetaFromRemoteFS(this.conf, appId, containerIdStr, nodeId, appOwner);
        }
        catch (Exception ex) {
            err.println(ex.getMessage());
            return -1;
        }
        if (containersLogMeta.isEmpty()) {
            if (containerIdStr != null && nodeId != null) {
                err.println("The container " + containerIdStr + " couldn't be found " + "on the node specified: " + nodeId);
            } else if (nodeId != null) {
                err.println("Can not find log metadata for any containers on " + nodeId);
            } else if (containerIdStr != null) {
                err.println("Can not find log metadata for container: " + containerIdStr);
            }
            return -1;
        }
        for (ContainerLogMeta containerLogMeta : containersLogMeta) {
            String containerString = String.format(CONTAINER_ON_NODE_PATTERN, containerLogMeta.getContainerId(), containerLogMeta.getNodeId());
            out.println(containerString);
            out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
            out.printf(PER_LOG_FILE_INFO_PATTERN, "LogFile", "LogLength", "LastModificationTime", "LogAggregationType");
            out.println(StringUtils.repeat((String)"=", (int)(containerString.length() * 2)));
            for (PerContainerLogFileInfo logMeta : containerLogMeta.getContainerLogMeta()) {
                out.printf(PER_LOG_FILE_INFO_PATTERN, logMeta.getFileName(), logMeta.getFileSize(), logMeta.getLastModifiedTime(), "AGGREGATED");
            }
        }
        return 0;
    }

    @InterfaceAudience.Private
    public void printNodesList(ContainerLogsRequest options, PrintStream out, PrintStream err) throws IOException {
        String appOwner;
        ApplicationId appId = options.getAppId();
        RemoteIterator<FileStatus> nodeFiles = this.getRemoteNodeFileDir(appId, appOwner = options.getAppOwner());
        if (nodeFiles == null) {
            return;
        }
        boolean foundNode = false;
        StringBuilder sb = new StringBuilder();
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            sb.append(thisNodeFile.getPath().getName() + "\n");
            foundNode = true;
        }
        if (!foundNode) {
            err.println("No nodes found that aggregated logs for the application: " + appId);
        } else {
            out.println(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void printContainersList(ContainerLogsRequest options, PrintStream out, PrintStream err) throws IOException {
        ApplicationId appId = options.getAppId();
        String appOwner = options.getAppOwner();
        String nodeId = options.getNodeId();
        String nodeIdStr = nodeId == null ? null : LogAggregationUtils.getNodeString(nodeId);
        RemoteIterator<FileStatus> nodeFiles = this.getRemoteNodeFileDir(appId, appOwner);
        if (nodeFiles == null) {
            return;
        }
        boolean foundAnyLogs = false;
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            if (nodeIdStr != null && !thisNodeFile.getPath().getName().contains(nodeIdStr) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    out.println(String.format(CONTAINER_ON_NODE_PATTERN, key, thisNodeFile.getPath().getName()));
                    foundAnyLogs = true;
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
        }
        if (!foundAnyLogs) {
            if (nodeId != null) {
                err.println("Can not find information for any containers on " + nodeId);
            } else {
                err.println("Can not find any container information for the application: " + appId);
            }
        }
    }

    private RemoteIterator<FileStatus> getRemoteNodeFileDir(ApplicationId appId, String appOwner) throws IOException {
        RemoteIterator<FileStatus> nodeFiles = null;
        try {
            nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, appId, appOwner);
        }
        catch (FileNotFoundException fnf) {
            LogCLIHelpers.logDirNotExist(LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, appOwner).toString());
        }
        catch (AccessDeniedException | AccessControlException ace) {
            LogCLIHelpers.logDirNoAccessPermission(LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, appOwner).toString(), appOwner, ace.getMessage());
        }
        return nodeFiles;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static void containerLogNotFound(String containerId) {
        System.err.println("Logs for container " + containerId + " are not present in this log-file.");
    }

    private static void logDirNotExist(String remoteAppLogDir) {
        System.err.println(remoteAppLogDir + " does not exist.");
        System.err.println("Log aggregation has not completed or is not enabled.");
    }

    private static void emptyLogDir(String remoteAppLogDir) {
        System.err.println(remoteAppLogDir + " does not have any log files.");
    }

    private static void logDirNoAccessPermission(String remoteAppLogDir, String appOwner, String errorMessage) throws IOException {
        System.err.println("Guessed logs' owner is " + appOwner + " and current user " + UserGroupInformation.getCurrentUser().getUserName() + " does not " + "have permission to access " + remoteAppLogDir + ". Error message found: " + errorMessage);
    }

    @InterfaceAudience.Private
    public PrintStream createPrintStream(String localDir, String nodeId, String containerId) throws IOException {
        PrintStream out = System.out;
        if (localDir != null && !localDir.isEmpty()) {
            Path nodePath = new Path(localDir, LogAggregationUtils.getNodeString(nodeId));
            Files.createDirectories(Paths.get(nodePath.toString(), new String[0]), new FileAttribute[0]);
            Path containerLogPath = new Path(nodePath, containerId);
            out = new PrintStream(containerLogPath.toString(), "UTF-8");
        }
        return out;
    }

    public void closePrintStream(PrintStream out) {
        if (out != System.out) {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public Set<String> listContainerLogs(ContainerLogsRequest options) throws IOException {
        HashSet<String> logTypes = new HashSet<String>();
        ApplicationId appId = options.getAppId();
        String appOwner = options.getAppOwner();
        String nodeId = options.getNodeId();
        String containerIdStr = options.getContainerId();
        boolean getAllContainers = containerIdStr == null;
        String nodeIdStr = nodeId == null ? null : LogAggregationUtils.getNodeString(nodeId);
        RemoteIterator<FileStatus> nodeFiles = this.getRemoteNodeFileDir(appId, appOwner);
        if (nodeFiles == null) {
            return logTypes;
        }
        block5: while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            if (nodeIdStr != null && !thisNodeFile.getPath().getName().contains(nodeIdStr) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    if (getAllContainers || key.toString().equals(containerIdStr)) {
                        try {
                            while (true) {
                                String logFile = (String)AggregatedLogFormat.LogReader.readContainerMetaDataAndSkipData(valueStream).getFirst();
                                logTypes.add(logFile);
                            }
                        }
                        catch (EOFException eof) {
                            if (!getAllContainers) continue block5;
                        }
                    }
                    key = new AggregatedLogFormat.LogKey();
                    valueStream = reader.next(key);
                }
            }
        }
        return logTypes;
    }
}

