/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.Console;
import org.apache.karaf.shell.console.ConsoleFactory;
import org.apache.karaf.shell.console.impl.jline.ConsoleImpl;
import org.apache.karaf.shell.console.impl.jline.StreamWrapUtil;
import org.osgi.framework.BundleContext;

public class ConsoleFactoryService
implements ConsoleFactory {
    private static final Class<?>[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private final BundleContext bundleContext;

    public ConsoleFactoryService(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Override
    public Console createLocal(CommandProcessor processor, ThreadIO threadIO, Terminal terminal, String encoding, Runnable closeCallback) {
        return this.create(processor, threadIO, StreamWrapUtil.reWrapIn(terminal, System.in), StreamWrapUtil.reWrap(System.out), StreamWrapUtil.reWrap(System.err), terminal, encoding, closeCallback);
    }

    @Override
    public Console create(CommandProcessor processor, ThreadIO threadIO, InputStream in, PrintStream out, PrintStream err, final Terminal terminal, String encoding, Runnable closeCallback) {
        ConsoleImpl console = new ConsoleImpl(processor, threadIO, in, out, err, terminal, encoding, closeCallback, this.bundleContext);
        CommandSession session = console.getSession();
        session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        session.put("#LINES", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getHeight());
            }
        });
        session.put("#COLUMNS", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getWidth());
            }
        });
        session.put(".jline.terminal", terminal);
        this.addSystemProperties(session);
        session.put("pid", this.getPid());
        return console;
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    private void addSystemProperties(CommandSession session) {
        Properties sysProps = System.getProperties();
        for (String string : sysProps.keySet()) {
            session.put(string, System.getProperty(string));
        }
    }

    @Override
    public void startConsoleAs(final Console console, final Subject subject, String consoleType) {
        final String userName = this.getUserName(subject);
        new Thread(console, "Karaf Console " + consoleType + " user " + userName){

            @Override
            public void run() {
                if (subject != null) {
                    CommandSession session = console.getSession();
                    session.put("USER", userName);
                    JaasHelper.doAs((Subject)subject, (PrivilegedAction)new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            this.doRun();
                            return null;
                        }
                    });
                } else {
                    this.doRun();
                }
            }

            protected void doRun() {
                super.run();
            }
        }.start();
    }

    private String getUserName(Subject subject) {
        if (subject != null && subject.getPrincipals().iterator().hasNext()) {
            return subject.getPrincipals(UserPrincipal.class).iterator().next().getName();
        }
        return null;
    }
}

