/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cgg.scripts.ScriptResourceLoader;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;

public class WebResourceLoader
implements ScriptResourceLoader {
    private static final Log logger = LogFactory.getLog(WebResourceLoader.class);
    private static final String URL_PARAM_USER = "_TRUST_USER_";
    private String context;
    private String userName;

    public WebResourceLoader() {
    }

    public WebResourceLoader(String context, String userName) {
        this.context = context;
        this.userName = userName;
    }

    public String getContextResourceURI(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }

    public InputStream getContextResource(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }

    public Reader getContextLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }

    public Reader getSystemLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }

    public InputStream getWebResource(String script) throws IOException, ScriptResourceNotFoundException {
        try {
            String url = script;
            if (this.userName != null) {
                url = url + (url.contains("?") ? "&" : "?") + URL_PARAM_USER + "=" + URLEncoder.encode(this.userName, StandardCharsets.UTF_8.name());
            }
            if (url.startsWith("/")) {
                String serverURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
                String contextPath = new URL(serverURL).getPath();
                String baseURL = serverURL.substring(0, serverURL.length() - contextPath.length());
                url = baseURL + url;
            }
            URLConnection connection = new URL(url).openConnection();
            return new BufferedInputStream(connection.getInputStream());
        }
        catch (MalformedURLException ex) {
            throw new ScriptResourceNotFoundException(script);
        }
    }
}

