/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import pt.webdetails.cgg.scripts.ScriptResourceLoader;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;
import pt.webdetails.cpf.repository.pentaho.unified.UserContentRepositoryAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class JCRScriptResourceLoader
implements ScriptResourceLoader {
    private String basePath;

    public JCRScriptResourceLoader(String basePath) {
        this.basePath = basePath;
    }

    public Reader getSystemLibraryScript(String s) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(s);
    }

    public Reader getContextLibraryScript(String s) throws IOException, ScriptResourceNotFoundException {
        return new InputStreamReader(this.getContextResource(s), CharsetHelper.getEncoding());
    }

    public String getContextResourceURI(String s) throws IOException, ScriptResourceNotFoundException {
        return "file://" + s;
    }

    public InputStream getContextResource(String s) throws IOException, ScriptResourceNotFoundException {
        if (this.basePath != null && this.basePath.startsWith("/system") || s.startsWith("/system")) {
            throw new ScriptResourceNotFoundException(s);
        }
        if (this.basePath != null && this.basePath.startsWith("/plugin") || s.startsWith("/plugin")) {
            throw new ScriptResourceNotFoundException(s);
        }
        UserContentRepositoryAccess repositoryAccess = new UserContentRepositoryAccess(PentahoSessionHolder.getSession(), s.startsWith("/") ? null : this.basePath);
        return repositoryAccess.getFileInputStream(s);
    }

    public InputStream getWebResource(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }
}

