/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.parsing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.transaction.BundleWideTxData;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.parsing.AnnotationParser;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxElementHandler
implements NamespaceHandler {
    public static final String DEFAULT_INTERCEPTOR_ID = "txinterceptor";
    public static final String INTERCEPTOR_BLUEPRINT_ID = "interceptor.blueprint.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(TxElementHandler.class);
    private TxComponentMetaDataHelper metaDataHelper;
    private Interceptor interceptor = null;
    private final ConcurrentMap<ComponentDefinitionRegistry, Bundle> registered = new ConcurrentHashMap<ComponentDefinitionRegistry, Bundle>();

    private void parseElement(Element elt, ComponentMetadata cm, ParserContext pc) {
        Node n;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parser asked to parse .. " + elt);
        }
        ComponentDefinitionRegistry cdr = pc.getComponentDefinitionRegistry();
        if ("transaction".equals(elt.getLocalName())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("parser adding interceptor for " + elt);
            }
            ComponentMetadata meta = cdr.getComponentDefinition("blueprintBundle");
            Bundle blueprintBundle = null;
            if (meta instanceof PassThroughMetadata) {
                blueprintBundle = (Bundle)((PassThroughMetadata)meta).getObject();
            }
            if (blueprintBundle != null) {
                this.registered.put(cdr, blueprintBundle);
                if (cm == null) {
                    String bean = elt.getAttribute("bean");
                    this.registerComponentsWithInterceptor(cdr, bean);
                    this.metaDataHelper.populateBundleWideTransactionData(pc.getComponentDefinitionRegistry(), elt.getAttribute("value"), elt.getAttribute("method"), bean);
                } else {
                    cdr.registerInterceptorWithComponent(cm, this.interceptor);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("parser setting comp trans data for " + elt.getAttribute("value") + "  " + elt.getAttribute("method"));
                    }
                    this.metaDataHelper.setComponentTransactionData(cdr, cm, elt.getAttribute("value"), elt.getAttribute("method"));
                }
            }
        } else if ("enable-annotations".equals(elt.getLocalName()) && ((n = elt.getChildNodes().item(0)) == null || Boolean.parseBoolean(n.getNodeValue())) && !cdr.containsComponentDefinition(".org_apache_aries_transaction_annotations")) {
            MutablePassThroughMetadata mptmd = (MutablePassThroughMetadata)pc.createMetadata(MutablePassThroughMetadata.class);
            mptmd.setId(".org_apache_aries_transaction_annotations");
            mptmd.setObject((Object)new AnnotationParser(cdr, this.interceptor, this.metaDataHelper));
            cdr.registerComponentDefinition((ComponentMetadata)mptmd);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parser done with " + elt);
        }
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata cm, ParserContext pc) {
        if (node instanceof Element) {
            Element elt = (Element)node;
            this.parseElement(elt, cm, pc);
        }
        return cm;
    }

    public Metadata parse(Element elt, ParserContext pc) {
        this.parseElement(elt, pc.getEnclosingComponent(), pc);
        return null;
    }

    public URL getSchemaLocation(String arg0) {
        if ("http://aries.apache.org/xmlns/transactions/v1.0.0".equals(arg0)) {
            return this.getClass().getResource("transactionv10.xsd");
        }
        if ("http://aries.apache.org/xmlns/transactions/v1.1.0".equals(arg0)) {
            return this.getClass().getResource("transactionv11.xsd");
        }
        if ("http://aries.apache.org/xmlns/transactions/v1.2.0".equals(arg0)) {
            return this.getClass().getResource("transactionv12.xsd");
        }
        return null;
    }

    public final void setTxMetaDataHelper(TxComponentMetaDataHelper transactionEnhancer) {
        this.metaDataHelper = transactionEnhancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBlueprintContainer(BlueprintContainer container) {
        String id = DEFAULT_INTERCEPTOR_ID;
        InputStream is = TxElementHandler.class.getResourceAsStream("/provider.properties");
        if (is != null) {
            try {
                Properties props = new Properties();
                props.load(is);
                if (props.containsKey(INTERCEPTOR_BLUEPRINT_ID)) {
                    id = props.getProperty(INTERCEPTOR_BLUEPRINT_ID);
                }
            }
            catch (IOException e) {
                LOGGER.error(Constants.MESSAGES.getMessage("unable.to.load.provider.props", new Object[0]), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    LOGGER.error(Constants.MESSAGES.getMessage("exception.closing.stream", new Object[0]), (Throwable)e2);
                }
            }
        }
        this.interceptor = (Interceptor)container.getComponentInstance(id);
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public boolean isRegistered(ComponentDefinitionRegistry cdr) {
        return this.registered.containsKey(cdr);
    }

    public void unregister(Bundle blueprintBundle) {
        Iterator it = this.registered.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (!blueprintBundle.equals(e.getValue())) continue;
            this.metaDataHelper.unregister((ComponentDefinitionRegistry)e.getKey());
            it.remove();
        }
    }

    private void registerComponentsWithInterceptor(ComponentDefinitionRegistry cdr, String bean) {
        Set ids = cdr.getComponentDefinitionNames();
        if (bean == null || bean.length() == 0) {
            for (String id : ids) {
                ComponentMetadata componentMetadata = cdr.getComponentDefinition(id);
                cdr.registerInterceptorWithComponent(componentMetadata, this.interceptor);
            }
        } else {
            BundleWideTxData data = new BundleWideTxData(null, "*", bean);
            for (Pattern p : data.getBean()) {
                for (String id : ids) {
                    Matcher m = p.matcher(id);
                    if (!m.matches()) continue;
                    ComponentMetadata componentMetadata = cdr.getComponentDefinition(id);
                    cdr.registerInterceptorWithComponent(componentMetadata, this.interceptor);
                }
            }
        }
    }
}

