/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.metrics.JvmPauseMonitorSource;

public interface MetricsRegionServerSource
extends BaseSource,
JvmPauseMonitorSource {
    public static final String METRICS_NAME = "Server";
    public static final String METRICS_CONTEXT = "regionserver";
    public static final String METRICS_DESCRIPTION = "Metrics about HBase RegionServer";
    public static final String METRICS_JMX_CONTEXT = "RegionServer,sub=Server";
    public static final String REGION_COUNT = "regionCount";
    public static final String REGION_COUNT_DESC = "Number of regions";
    public static final String STORE_COUNT = "storeCount";
    public static final String STORE_COUNT_DESC = "Number of Stores";
    public static final String WALFILE_COUNT = "hlogFileCount";
    public static final String WALFILE_COUNT_DESC = "Number of WAL Files";
    public static final String WALFILE_SIZE = "hlogFileSize";
    public static final String WALFILE_SIZE_DESC = "Size of all WAL Files";
    public static final String STOREFILE_COUNT = "storeFileCount";
    public static final String STOREFILE_COUNT_DESC = "Number of Store Files";
    public static final String MEMSTORE_SIZE = "memStoreSize";
    public static final String MEMSTORE_SIZE_DESC = "Size of the memstore";
    public static final String STOREFILE_SIZE = "storeFileSize";
    public static final String MAX_STORE_FILE_AGE = "maxStoreFileAge";
    public static final String MIN_STORE_FILE_AGE = "minStoreFileAge";
    public static final String AVG_STORE_FILE_AGE = "avgStoreFileAge";
    public static final String NUM_REFERENCE_FILES = "numReferenceFiles";
    public static final String MAX_STORE_FILE_AGE_DESC = "Max age of store files hosted on this region server";
    public static final String MIN_STORE_FILE_AGE_DESC = "Min age of store files hosted on this region server";
    public static final String AVG_STORE_FILE_AGE_DESC = "Average age of store files hosted on this region server";
    public static final String NUM_REFERENCE_FILES_DESC = "Number of reference file on this region server";
    public static final String STOREFILE_SIZE_DESC = "Size of storefiles being served.";
    public static final String TOTAL_REQUEST_COUNT = "totalRequestCount";
    public static final String TOTAL_REQUEST_COUNT_DESC = "Total number of requests this RegionServer has answered.";
    public static final String READ_REQUEST_COUNT = "readRequestCount";
    public static final String READ_REQUEST_COUNT_DESC = "Number of read requests this region server has answered.";
    public static final String WRITE_REQUEST_COUNT = "writeRequestCount";
    public static final String WRITE_REQUEST_COUNT_DESC = "Number of mutation requests this region server has answered.";
    public static final String CHECK_MUTATE_FAILED_COUNT = "checkMutateFailedCount";
    public static final String CHECK_MUTATE_FAILED_COUNT_DESC = "Number of Check and Mutate calls that failed the checks.";
    public static final String CHECK_MUTATE_PASSED_COUNT = "checkMutatePassedCount";
    public static final String CHECK_MUTATE_PASSED_COUNT_DESC = "Number of Check and Mutate calls that passed the checks.";
    public static final String STOREFILE_INDEX_SIZE = "storeFileIndexSize";
    public static final String STOREFILE_INDEX_SIZE_DESC = "Size of indexes in storefiles on disk.";
    public static final String STATIC_INDEX_SIZE = "staticIndexSize";
    public static final String STATIC_INDEX_SIZE_DESC = "Uncompressed size of the static indexes.";
    public static final String STATIC_BLOOM_SIZE = "staticBloomSize";
    public static final String STATIC_BLOOM_SIZE_DESC = "Uncompressed size of the static bloom filters.";
    public static final String NUMBER_OF_MUTATIONS_WITHOUT_WAL = "mutationsWithoutWALCount";
    public static final String NUMBER_OF_MUTATIONS_WITHOUT_WAL_DESC = "Number of mutations that have been sent by clients with the write ahead logging turned off.";
    public static final String DATA_SIZE_WITHOUT_WAL = "mutationsWithoutWALSize";
    public static final String DATA_SIZE_WITHOUT_WAL_DESC = "Size of data that has been sent by clients with the write ahead logging turned off.";
    public static final String PERCENT_FILES_LOCAL = "percentFilesLocal";
    public static final String PERCENT_FILES_LOCAL_DESC = "The percent of HFiles that are stored on the local hdfs data node.";
    public static final String PERCENT_FILES_LOCAL_SECONDARY_REGIONS = "percentFilesLocalSecondaryRegions";
    public static final String PERCENT_FILES_LOCAL_SECONDARY_REGIONS_DESC = "The percent of HFiles used by secondary regions that are stored on the local hdfs data node.";
    public static final String SPLIT_QUEUE_LENGTH = "splitQueueLength";
    public static final String SPLIT_QUEUE_LENGTH_DESC = "Length of the queue for splits.";
    public static final String COMPACTION_QUEUE_LENGTH = "compactionQueueLength";
    public static final String LARGE_COMPACTION_QUEUE_LENGTH = "largeCompactionQueueLength";
    public static final String SMALL_COMPACTION_QUEUE_LENGTH = "smallCompactionQueueLength";
    public static final String COMPACTION_QUEUE_LENGTH_DESC = "Length of the queue for compactions.";
    public static final String LARGE_COMPACTION_QUEUE_LENGTH_DESC = "Length of the queue for compactions with input size larger than throttle threshold (2.5GB by default)";
    public static final String SMALL_COMPACTION_QUEUE_LENGTH_DESC = "Length of the queue for compactions with input size smaller than throttle threshold (2.5GB by default)";
    public static final String FLUSH_QUEUE_LENGTH = "flushQueueLength";
    public static final String FLUSH_QUEUE_LENGTH_DESC = "Length of the queue for region flushes";
    public static final String BLOCK_CACHE_FREE_SIZE = "blockCacheFreeSize";
    public static final String BLOCK_CACHE_FREE_DESC = "Size of the block cache that is not occupied.";
    public static final String BLOCK_CACHE_COUNT = "blockCacheCount";
    public static final String BLOCK_CACHE_COUNT_DESC = "Number of block in the block cache.";
    public static final String BLOCK_CACHE_SIZE = "blockCacheSize";
    public static final String BLOCK_CACHE_SIZE_DESC = "Size of the block cache.";
    public static final String BLOCK_CACHE_HIT_COUNT = "blockCacheHitCount";
    public static final String BLOCK_CACHE_HIT_COUNT_DESC = "Count of the hit on the block cache.";
    public static final String BLOCK_CACHE_PRIMARY_HIT_COUNT = "blockCacheHitCountPrimary";
    public static final String BLOCK_CACHE_PRIMARY_HIT_COUNT_DESC = "Count of hit on primary replica in the block cache.";
    public static final String BLOCK_CACHE_MISS_COUNT = "blockCacheMissCount";
    public static final String BLOCK_COUNT_MISS_COUNT_DESC = "Number of requests for a block that missed the block cache.";
    public static final String BLOCK_CACHE_PRIMARY_MISS_COUNT = "blockCacheMissCountPrimary";
    public static final String BLOCK_COUNT_PRIMARY_MISS_COUNT_DESC = "Number of requests for a block of primary replica that missed the block cache.";
    public static final String BLOCK_CACHE_EVICTION_COUNT = "blockCacheEvictionCount";
    public static final String BLOCK_CACHE_EVICTION_COUNT_DESC = "Count of the number of blocks evicted from the block cache.";
    public static final String BLOCK_CACHE_PRIMARY_EVICTION_COUNT = "blockCacheEvictionCountPrimary";
    public static final String BLOCK_CACHE_PRIMARY_EVICTION_COUNT_DESC = "Count of the number of blocks evicted from primary replica in the block cache.";
    public static final String BLOCK_CACHE_HIT_PERCENT = "blockCacheCountHitPercent";
    public static final String BLOCK_CACHE_HIT_PERCENT_DESC = "Percent of block cache requests that are hits";
    public static final String BLOCK_CACHE_EXPRESS_HIT_PERCENT = "blockCacheExpressHitPercent";
    public static final String BLOCK_CACHE_EXPRESS_HIT_PERCENT_DESC = "The percent of the time that requests with the cache turned on hit the cache.";
    public static final String BLOCK_CACHE_DATA_MISS_COUNT = "blockCacheDataMissCount";
    public static final String BLOCK_CACHE_ENCODED_DATA_MISS_COUNT = "blockCacheEncodedDataMissCount";
    public static final String BLOCK_CACHE_LEAF_INDEX_MISS_COUNT = "blockCacheLeafIndexMissCount";
    public static final String BLOCK_CACHE_BLOOM_CHUNK_MISS_COUNT = "blockCacheBloomChunkMissCount";
    public static final String BLOCK_CACHE_META_MISS_COUNT = "blockCacheMetaMissCount";
    public static final String BLOCK_CACHE_ROOT_INDEX_MISS_COUNT = "blockCacheRootIndexMissCount";
    public static final String BLOCK_CACHE_INTERMEDIATE_INDEX_MISS_COUNT = "blockCacheIntermediateIndexMissCount";
    public static final String BLOCK_CACHE_FILE_INFO_MISS_COUNT = "blockCacheFileInfoMissCount";
    public static final String BLOCK_CACHE_GENERAL_BLOOM_META_MISS_COUNT = "blockCacheGeneralBloomMetaMissCount";
    public static final String BLOCK_CACHE_DELETE_FAMILY_BLOOM_MISS_COUNT = "blockCacheDeleteFamilyBloomMissCount";
    public static final String BLOCK_CACHE_TRAILER_MISS_COUNT = "blockCacheTrailerMissCount";
    public static final String BLOCK_CACHE_DATA_HIT_COUNT = "blockCacheDataHitCount";
    public static final String BLOCK_CACHE_ENCODED_DATA_HIT_COUNT = "blockCacheEncodedDataHitCount";
    public static final String BLOCK_CACHE_LEAF_INDEX_HIT_COUNT = "blockCacheLeafIndexHitCount";
    public static final String BLOCK_CACHE_BLOOM_CHUNK_HIT_COUNT = "blockCacheBloomChunkHitCount";
    public static final String BLOCK_CACHE_META_HIT_COUNT = "blockCacheMetaHitCount";
    public static final String BLOCK_CACHE_ROOT_INDEX_HIT_COUNT = "blockCacheRootIndexHitCount";
    public static final String BLOCK_CACHE_INTERMEDIATE_INDEX_HIT_COUNT = "blockCacheIntermediateIndexHitCount";
    public static final String BLOCK_CACHE_FILE_INFO_HIT_COUNT = "blockCacheFileInfoHitCount";
    public static final String BLOCK_CACHE_GENERAL_BLOOM_META_HIT_COUNT = "blockCacheGeneralBloomMetaHitCount";
    public static final String BLOCK_CACHE_DELETE_FAMILY_BLOOM_HIT_COUNT = "blockCacheDeleteFamilyBloomHitCount";
    public static final String BLOCK_CACHE_TRAILER_HIT_COUNT = "blockCacheTrailerHitCount";
    public static final String RS_START_TIME_NAME = "regionServerStartTime";
    public static final String ZOOKEEPER_QUORUM_NAME = "zookeeperQuorum";
    public static final String SERVER_NAME_NAME = "serverName";
    public static final String CLUSTER_ID_NAME = "clusterId";
    public static final String RS_START_TIME_DESC = "RegionServer Start Time";
    public static final String ZOOKEEPER_QUORUM_DESC = "Zookeeper Quorum";
    public static final String SERVER_NAME_DESC = "Server Name";
    public static final String CLUSTER_ID_DESC = "Cluster Id";
    public static final String UPDATES_BLOCKED_TIME = "updatesBlockedTime";
    public static final String UPDATES_BLOCKED_DESC = "Number of MS updates have been blocked so that the memstore can be flushed.";
    public static final String DELETE_KEY = "delete";
    public static final String GET_SIZE_KEY = "getSize";
    public static final String GET_KEY = "get";
    public static final String INCREMENT_KEY = "increment";
    public static final String MUTATE_KEY = "mutate";
    public static final String APPEND_KEY = "append";
    public static final String REPLAY_KEY = "replay";
    public static final String SCAN_SIZE_KEY = "scanSize";
    public static final String SCAN_TIME_KEY = "scanTime";
    public static final String SLOW_MUTATE_KEY = "slowPutCount";
    public static final String SLOW_GET_KEY = "slowGetCount";
    public static final String SLOW_DELETE_KEY = "slowDeleteCount";
    public static final String SLOW_INCREMENT_KEY = "slowIncrementCount";
    public static final String SLOW_APPEND_KEY = "slowAppendCount";
    public static final String SLOW_MUTATE_DESC = "The number of Multis that took over 1000ms to complete";
    public static final String SLOW_DELETE_DESC = "The number of Deletes that took over 1000ms to complete";
    public static final String SLOW_GET_DESC = "The number of Gets that took over 1000ms to complete";
    public static final String SLOW_INCREMENT_DESC = "The number of Increments that took over 1000ms to complete";
    public static final String SLOW_APPEND_DESC = "The number of Appends that took over 1000ms to complete";
    public static final String FLUSHED_CELLS = "flushedCellsCount";
    public static final String FLUSHED_CELLS_DESC = "The number of cells flushed to disk";
    public static final String FLUSHED_CELLS_SIZE = "flushedCellsSize";
    public static final String FLUSHED_CELLS_SIZE_DESC = "The total amount of data flushed to disk, in bytes";
    public static final String COMPACTED_CELLS = "compactedCellsCount";
    public static final String COMPACTED_CELLS_DESC = "The number of cells processed during minor compactions";
    public static final String COMPACTED_CELLS_SIZE = "compactedCellsSize";
    public static final String COMPACTED_CELLS_SIZE_DESC = "The total amount of data processed during minor compactions, in bytes";
    public static final String MAJOR_COMPACTED_CELLS = "majorCompactedCellsCount";
    public static final String MAJOR_COMPACTED_CELLS_DESC = "The number of cells processed during major compactions";
    public static final String MAJOR_COMPACTED_CELLS_SIZE = "majorCompactedCellsSize";
    public static final String MAJOR_COMPACTED_CELLS_SIZE_DESC = "The total amount of data processed during major compactions, in bytes";
    public static final String CELLS_COUNT_COMPACTED_TO_MOB = "cellsCountCompactedToMob";
    public static final String CELLS_COUNT_COMPACTED_TO_MOB_DESC = "The number of cells moved to mob during compaction";
    public static final String CELLS_COUNT_COMPACTED_FROM_MOB = "cellsCountCompactedFromMob";
    public static final String CELLS_COUNT_COMPACTED_FROM_MOB_DESC = "The number of cells moved from mob during compaction";
    public static final String CELLS_SIZE_COMPACTED_TO_MOB = "cellsSizeCompactedToMob";
    public static final String CELLS_SIZE_COMPACTED_TO_MOB_DESC = "The total amount of cells move to mob during compaction, in bytes";
    public static final String CELLS_SIZE_COMPACTED_FROM_MOB = "cellsSizeCompactedFromMob";
    public static final String CELLS_SIZE_COMPACTED_FROM_MOB_DESC = "The total amount of cells move from mob during compaction, in bytes";
    public static final String MOB_FLUSH_COUNT = "mobFlushCount";
    public static final String MOB_FLUSH_COUNT_DESC = "The number of the flushes in mob-enabled stores";
    public static final String MOB_FLUSHED_CELLS_COUNT = "mobFlushedCellsCount";
    public static final String MOB_FLUSHED_CELLS_COUNT_DESC = "The number of mob cells flushed to disk";
    public static final String MOB_FLUSHED_CELLS_SIZE = "mobFlushedCellsSize";
    public static final String MOB_FLUSHED_CELLS_SIZE_DESC = "The total amount of mob cells flushed to disk, in bytes";
    public static final String MOB_SCAN_CELLS_COUNT = "mobScanCellsCount";
    public static final String MOB_SCAN_CELLS_COUNT_DESC = "The number of scanned mob cells";
    public static final String MOB_SCAN_CELLS_SIZE = "mobScanCellsSize";
    public static final String MOB_SCAN_CELLS_SIZE_DESC = "The total amount of scanned mob cells, in bytes";
    public static final String MOB_FILE_CACHE_ACCESS_COUNT = "mobFileCacheAccessCount";
    public static final String MOB_FILE_CACHE_ACCESS_COUNT_DESC = "The count of accesses to the mob file cache";
    public static final String MOB_FILE_CACHE_MISS_COUNT = "mobFileCacheMissCount";
    public static final String MOB_FILE_CACHE_MISS_COUNT_DESC = "The count of misses to the mob file cache";
    public static final String MOB_FILE_CACHE_HIT_PERCENT = "mobFileCacheHitPercent";
    public static final String MOB_FILE_CACHE_HIT_PERCENT_DESC = "The hit percent to the mob file cache";
    public static final String MOB_FILE_CACHE_EVICTED_COUNT = "mobFileCacheEvictedCount";
    public static final String MOB_FILE_CACHE_EVICTED_COUNT_DESC = "The number of items evicted from the mob file cache";
    public static final String MOB_FILE_CACHE_COUNT = "mobFileCacheCount";
    public static final String MOB_FILE_CACHE_COUNT_DESC = "The count of cached mob files";
    public static final String BLOCKED_REQUESTS_COUNT = "blockedRequestCount";
    public static final String BLOCKED_REQUESTS_COUNT_DESC = "The number of blocked requests because of memstore size is larger than blockingMemStoreSize";
    public static final String SPLIT_KEY = "splitTime";
    public static final String SPLIT_REQUEST_KEY = "splitRequestCount";
    public static final String SPLIT_REQUEST_DESC = "Number of splits requested";
    public static final String SPLIT_SUCCESS_KEY = "splitSuccessCount";
    public static final String SPLIT_SUCCESS_DESC = "Number of successfully executed splits";
    public static final String FLUSH_TIME = "flushTime";
    public static final String FLUSH_TIME_DESC = "Histogram for the time in millis for memstore flush";
    public static final String FLUSH_MEMSTORE_SIZE = "flushMemstoreSize";
    public static final String FLUSH_MEMSTORE_SIZE_DESC = "Histogram for number of bytes in the memstore for a flush";
    public static final String FLUSH_OUTPUT_SIZE = "flushOutputSize";
    public static final String FLUSH_OUTPUT_SIZE_DESC = "Histogram for number of bytes in the resulting file for a flush";
    public static final String FLUSHED_OUTPUT_BYTES = "flushedOutputBytes";
    public static final String FLUSHED_OUTPUT_BYTES_DESC = "Total number of bytes written from flush";
    public static final String FLUSHED_MEMSTORE_BYTES = "flushedMemstoreBytes";
    public static final String FLUSHED_MEMSTORE_BYTES_DESC = "Total number of bytes of cells in memstore from flush";
    public static final String COMPACTION_TIME = "compactionTime";
    public static final String COMPACTION_TIME_DESC = "Histogram for the time in millis for compaction, both major and minor";
    public static final String COMPACTION_INPUT_FILE_COUNT = "compactionInputFileCount";
    public static final String COMPACTION_INPUT_FILE_COUNT_DESC = "Histogram for the compaction input number of files, both major and minor";
    public static final String COMPACTION_INPUT_SIZE = "compactionInputSize";
    public static final String COMPACTION_INPUT_SIZE_DESC = "Histogram for the compaction total input file sizes, both major and minor";
    public static final String COMPACTION_OUTPUT_FILE_COUNT = "compactionOutputFileCount";
    public static final String COMPACTION_OUTPUT_FILE_COUNT_DESC = "Histogram for the compaction output number of files, both major and minor";
    public static final String COMPACTION_OUTPUT_SIZE = "compactionOutputSize";
    public static final String COMPACTION_OUTPUT_SIZE_DESC = "Histogram for the compaction total output file sizes, both major and minor";
    public static final String COMPACTED_INPUT_BYTES = "compactedInputBytes";
    public static final String COMPACTED_INPUT_BYTES_DESC = "Total number of bytes that is read for compaction, both major and minor";
    public static final String COMPACTED_OUTPUT_BYTES = "compactedOutputBytes";
    public static final String COMPACTED_OUTPUT_BYTES_DESC = "Total number of bytes that is output from compaction, both major and minor";
    public static final String MAJOR_COMPACTION_TIME = "majorCompactionTime";
    public static final String MAJOR_COMPACTION_TIME_DESC = "Histogram for the time in millis for compaction, major only";
    public static final String MAJOR_COMPACTION_INPUT_FILE_COUNT = "majorCompactionInputFileCount";
    public static final String MAJOR_COMPACTION_INPUT_FILE_COUNT_DESC = "Histogram for the compaction input number of files, major only";
    public static final String MAJOR_COMPACTION_INPUT_SIZE = "majorCompactionInputSize";
    public static final String MAJOR_COMPACTION_INPUT_SIZE_DESC = "Histogram for the compaction total input file sizes, major only";
    public static final String MAJOR_COMPACTION_OUTPUT_FILE_COUNT = "majorCompactionOutputFileCount";
    public static final String MAJOR_COMPACTION_OUTPUT_FILE_COUNT_DESC = "Histogram for the compaction output number of files, major only";
    public static final String MAJOR_COMPACTION_OUTPUT_SIZE = "majorCompactionOutputSize";
    public static final String MAJOR_COMPACTION_OUTPUT_SIZE_DESC = "Histogram for the compaction total output file sizes, major only";
    public static final String MAJOR_COMPACTED_INPUT_BYTES = "majorCompactedInputBytes";
    public static final String MAJOR_COMPACTED_INPUT_BYTES_DESC = "Total number of bytes that is read for compaction, major only";
    public static final String MAJOR_COMPACTED_OUTPUT_BYTES = "majorCompactedOutputBytes";
    public static final String MAJOR_COMPACTED_OUTPUT_BYTES_DESC = "Total number of bytes that is output from compaction, major only";
    public static final String RPC_GET_REQUEST_COUNT = "rpcGetRequestCount";
    public static final String RPC_GET_REQUEST_COUNT_DESC = "Number of rpc get requests this region server has answered.";
    public static final String RPC_SCAN_REQUEST_COUNT = "rpcScanRequestCount";
    public static final String RPC_SCAN_REQUEST_COUNT_DESC = "Number of rpc scan requests this region server has answered.";
    public static final String RPC_MULTI_REQUEST_COUNT = "rpcMultiRequestCount";
    public static final String RPC_MULTI_REQUEST_COUNT_DESC = "Number of rpc multi requests this region server has answered.";
    public static final String RPC_MUTATE_REQUEST_COUNT = "rpcMutateRequestCount";
    public static final String RPC_MUTATE_REQUEST_COUNT_DESC = "Number of rpc mutation requests this region server has answered.";
    public static final String AVERAGE_REGION_SIZE = "averageRegionSize";
    public static final String AVERAGE_REGION_SIZE_DESC = "Average region size over the region server including memstore and storefile sizes.";

    public void updatePut(long var1);

    public void updateDelete(long var1);

    public void updateGet(long var1);

    public void updateIncrement(long var1);

    public void updateAppend(long var1);

    public void updateReplay(long var1);

    public void updateScanSize(long var1);

    public void updateScanTime(long var1);

    public void incrSlowPut();

    public void incrSlowDelete();

    public void incrSlowGet();

    public void incrSlowIncrement();

    public void incrSlowAppend();

    public void updateSplitTime(long var1);

    public void incrSplitRequest();

    public void incrSplitSuccess();

    public void updateFlushTime(long var1);

    public void updateFlushMemstoreSize(long var1);

    public void updateFlushOutputSize(long var1);

    public void updateCompactionTime(boolean var1, long var2);

    public void updateCompactionInputFileCount(boolean var1, long var2);

    public void updateCompactionInputSize(boolean var1, long var2);

    public void updateCompactionOutputFileCount(boolean var1, long var2);

    public void updateCompactionOutputSize(boolean var1, long var2);
}

