/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.KillTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsKillXCommand
extends KillTransitionXCommand<CoordinatorActionInfo> {
    private String jobId;
    private CoordinatorJobBean coordJob;
    List<CoordinatorActionBean> coordActions;
    private String rangeType;
    private String scope;
    private JPAService jpaService = null;

    public CoordActionsKillXCommand(String id, String rangeType, String scope) {
        super("coord_action_kill", "coord_action_kill", 2);
        this.jobId = id;
        this.rangeType = ParamChecker.notEmpty(rangeType, "rangeType");
        this.scope = ParamChecker.notEmpty(scope, "scope");
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_ACTION_KILL, this.jobId);
            LogUtils.setLogInfo(this.coordJob);
            this.coordActions = CoordUtils.getCoordActions(this.rangeType, this.coordJob.getId(), this.scope, true);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.coordJob.getStatus() == Job.Status.SUCCEEDED || this.coordJob.getStatus() == Job.Status.FAILED || this.coordJob.getStatus() == Job.Status.DONEWITHERROR || this.coordJob.getStatus() == Job.Status.KILLED) {
            this.LOG.info("Coord actions not killed - job either finished SUCCEEDED, FAILED, KILLED or DONEWITHERROR, job id = " + this.jobId + ", status = " + this.coordJob.getStatus());
            throw new PreconditionException(ErrorCode.E1020, this.jobId);
        }
    }

    @Override
    public void transitToNext() {
    }

    @Override
    public void killChildren() throws CommandException {
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        for (CoordinatorActionBean coordAction : this.coordActions) {
            coordAction.setStatus(CoordinatorAction.Status.KILLED);
            coordAction.setLastModifiedTime(new Date());
            if (coordAction.getExternalId() != null) {
                this.queue(new KillXCommand(coordAction.getExternalId()));
                coordAction.incrementAndGetPending();
            } else {
                coordAction.setPending(0);
            }
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, coordAction));
            if (EventHandlerService.isEnabled()) {
                CoordinatorXCommand.generateEvent(coordAction, this.coordJob.getUser(), this.coordJob.getAppName(), coordAction.getCreatedTime());
            }
            this.queue(new CoordActionNotificationXCommand(coordAction), 100L);
        }
        CoordinatorActionInfo coordInfo = new CoordinatorActionInfo(this.coordActions);
        this.ret = coordInfo;
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void updateJob() throws CommandException {
        this.coordJob.setPending();
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING, this.coordJob));
    }

    @Override
    public void notifyParent() throws CommandException {
    }
}

