/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.top.metrics;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TopMetrics
implements MetricsSource {
    public static final Logger LOG = LoggerFactory.getLogger(TopMetrics.class);
    public static final String TOPMETRICS_METRICS_SOURCE_NAME = "NNTopUserOpCounts";
    public static final String FILES_IN_GETLISTING = "filesInGetListing";
    private final boolean isMetricsSourceEnabled;
    final Map<Integer, RollingWindowManager> rollingWindowManagers = new HashMap<Integer, RollingWindowManager>();

    private static void logConf(Configuration conf) {
        LOG.info("NNTop conf: dfs.namenode.top.window.num.buckets = " + conf.get("dfs.namenode.top.window.num.buckets"));
        LOG.info("NNTop conf: dfs.namenode.top.num.users = " + conf.get("dfs.namenode.top.num.users"));
        LOG.info("NNTop conf: dfs.namenode.top.windows.minutes = " + conf.get("dfs.namenode.top.windows.minutes"));
    }

    public TopMetrics(Configuration conf, int[] reportingPeriods) {
        TopMetrics.logConf(conf);
        for (int i = 0; i < reportingPeriods.length; ++i) {
            this.rollingWindowManagers.put(reportingPeriods[i], new RollingWindowManager(conf, reportingPeriods[i]));
        }
        this.isMetricsSourceEnabled = conf.getBoolean("dfs.namenode.top.enabled", true);
    }

    public List<RollingWindowManager.TopWindow> getTopWindows() {
        long monoTime = Time.monotonicNow();
        ArrayList windows = Lists.newArrayListWithCapacity((int)this.rollingWindowManagers.size());
        for (Map.Entry<Integer, RollingWindowManager> entry : this.rollingWindowManagers.entrySet()) {
            RollingWindowManager.TopWindow window = entry.getValue().snapshot(monoTime);
            windows.add(window);
        }
        return windows;
    }

    public void report(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status) {
        this.report(userName, cmd, 1);
    }

    public void reportFilesInGetListing(String userName, int numFiles) {
        this.report(userName, FILES_IN_GETLISTING, numFiles);
    }

    public void report(String userName, String cmd, int delta) {
        long currTime = Time.monotonicNow();
        this.report(currTime, userName, cmd, delta);
    }

    public void report(long currTime, String userName, String cmd, int delta) {
        LOG.debug("a metric is reported: cmd: {} user: {}", (Object)cmd, (Object)userName);
        userName = UserGroupInformation.trimLoginMethod((String)userName);
        for (RollingWindowManager rollingWindowManager : this.rollingWindowManagers.values()) {
            rollingWindowManager.recordMetric(currTime, cmd, userName, delta);
            if (cmd.equals(FILES_IN_GETLISTING)) continue;
            rollingWindowManager.recordMetric(currTime, "*", userName, delta);
        }
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        if (!this.isMetricsSourceEnabled) {
            return;
        }
        for (RollingWindowManager.TopWindow window : this.getTopWindows()) {
            MetricsRecordBuilder rb = collector.addRecord(this.buildOpRecordName(window)).setContext("dfs");
            for (RollingWindowManager.Op op : window.getOps()) {
                rb.addCounter(this.buildOpTotalCountMetricsInfo(op), op.getTotalCount());
                for (RollingWindowManager.User user : op.getTopUsers()) {
                    rb.addCounter(this.buildOpRecordMetricsInfo(op, user), user.getCount());
                }
            }
        }
    }

    private String buildOpRecordName(RollingWindowManager.TopWindow window) {
        return "NNTopUserOpCounts.windowMs=" + window.getWindowLenMs();
    }

    private MetricsInfo buildOpTotalCountMetricsInfo(RollingWindowManager.Op op) {
        return Interns.info((String)("op=" + StringUtils.deleteWhitespace((String)op.getOpType()) + ".TotalCount"), (String)"Total operation count");
    }

    private MetricsInfo buildOpRecordMetricsInfo(RollingWindowManager.Op op, RollingWindowManager.User user) {
        return Interns.info((String)("op=" + StringUtils.deleteWhitespace((String)op.getOpType()) + ".user=" + user.getUser() + ".count"), (String)"Total operations performed by user");
    }
}

