/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.big.data.api.jdbc.DriverLocator;
import org.pentaho.big.data.kettle.plugins.hive.BaseSimbaDatabaseMeta;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;

@DatabaseMetaPlugin(type="IMPALASIMBA", typeDescription="Cloudera Impala")
public class ImpalaSimbaDatabaseMeta
extends BaseSimbaDatabaseMeta {
    protected static final String JAR_FILE = "ImpalaJDBC41.jar";
    protected static final String JDBC_URL_PREFIX = "jdbc:impala://";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.ImpalaSimbaDriver";
    protected static final int DEFAULT_PORT = 21050;
    protected static final String SOCKET_TIMEOUT_OPTION = "SocketTimeout";

    public ImpalaSimbaDatabaseMeta(DriverLocator driverLocator) {
        super(driverLocator);
    }

    @Override
    protected String getJdbcPrefix() {
        return JDBC_URL_PREFIX;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    public int getDefaultDatabasePort() {
        return 21050;
    }

    public Map<String, String> getDefaultOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(String.format("%s.%s", this.getPluginId(), SOCKET_TIMEOUT_OPTION), "10");
        return options;
    }
}

