/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.processor.binding.RestBindingProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;

@Metadata(label="rest")
@XmlRootElement(name="restBinding")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestBindingDefinition
extends NoOutputDefinition<RestBindingDefinition> {
    @XmlTransient
    private Map<String, String> defaultValues;
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    @Metadata(defaultValue="off")
    private RestBindingMode bindingMode;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private String outType;
    @XmlAttribute
    private Boolean skipBindingOnErrorCode;
    @XmlAttribute
    private Boolean enableCORS;
    @XmlAttribute
    private String component;

    public String toString() {
        return "RestBinding";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        CamelContext context = routeContext.getCamelContext();
        RestConfiguration config = context.getRestConfiguration(this.component, true);
        String mode = config.getBindingMode().name();
        if (this.bindingMode != null) {
            mode = this.bindingMode.name();
        }
        boolean cors = config.isEnableCORS();
        if (this.enableCORS != null) {
            cors = this.enableCORS;
        }
        boolean skip = config.isSkipBindingOnErrorCode();
        if (this.skipBindingOnErrorCode != null) {
            skip = this.skipBindingOnErrorCode;
        }
        Map<String, String> corsHeaders = config.getCorsHeaders();
        if (mode == null || "off".equals(mode)) {
            return new RestBindingProcessor(context, null, null, null, null, this.consumes, this.produces, mode, skip, cors, corsHeaders, this.defaultValues);
        }
        String name = config.getJsonDataFormat();
        if (name != null) {
            Object instance = context.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "json-jackson";
        }
        DataFormat json = context.resolveDataFormat(name);
        DataFormat outJson = context.resolveDataFormat(name);
        if (mode.contains("json") && json == null) {
            throw new IllegalArgumentException("JSon DataFormat " + name + " not found.");
        }
        if (json != null) {
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                IntrospectionSupport.setProperty(context.getTypeConverter(), json, "unmarshalType", clazz);
                IntrospectionSupport.setProperty(context.getTypeConverter(), json, "useList", (Object)this.type.endsWith("[]"));
            }
            this.setAdditionalConfiguration(config, context, json, "json.in.");
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJson, "unmarshalType", outClazz);
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJson, "useList", (Object)this.outType.endsWith("[]"));
            }
            this.setAdditionalConfiguration(config, context, outJson, "json.out.");
        }
        if ((name = config.getXmlDataFormat()) != null) {
            Object instance = context.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "jaxb";
        }
        DataFormat jaxb = context.resolveDataFormat(name);
        DataFormat outJaxb = context.resolveDataFormat(name);
        if (mode.contains("xml") && jaxb == null) {
            throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
        }
        if (jaxb != null) {
            JAXBContext jc;
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), jaxb, "context", jc2);
            }
            this.setAdditionalConfiguration(config, context, jaxb, "xml.in.");
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = context.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJaxb, "context", jc);
            } else if (clazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(context.getTypeConverter(), outJaxb, "context", jc);
            }
            this.setAdditionalConfiguration(config, context, outJaxb, "xml.out.");
        }
        return new RestBindingProcessor(context, json, jaxb, outJson, outJaxb, this.consumes, this.produces, mode, skip, cors, corsHeaders, this.defaultValues);
    }

    private void setAdditionalConfiguration(RestConfiguration config, CamelContext context, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : config.getDataFormatProperties().entrySet()) {
                String key = entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            EndpointHelper.setReferenceProperties(context, dataFormat, copy);
            EndpointHelper.setProperties(context, dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void addDefaultValue(String paramName, String defaultValue) {
        if (this.defaultValues == null) {
            this.defaultValues = new HashMap<String, String>();
        }
        this.defaultValues.put(paramName, defaultValue);
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getComponent() {
        return this.component;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public Boolean getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(Boolean enableCORS) {
        this.enableCORS = enableCORS;
    }
}

