/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.main.MainSupport;

public class Main
extends MainSupport {
    protected static Main instance;
    protected final SimpleRegistry registry = new SimpleRegistry();

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.run(args);
        System.exit(main.getExitCode());
    }

    public static Main getInstance() {
        return instance;
    }

    public void bind(String name, Object bean) {
        this.registry.put(name, bean);
    }

    public Object lookup(String name) {
        return this.registry.get(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.registry.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.findByTypeWithName(type);
    }

    public CamelContext getOrCreateCamelContext() {
        Map<String, CamelContext> map = this.getCamelContextMap();
        if (map.size() >= 1) {
            return map.values().iterator().next();
        }
        throw new IllegalStateException("Error creating CamelContext");
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.postProcessContext();
        if (this.getCamelContexts().size() > 0) {
            this.getCamelContexts().get(0).start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.getCamelContexts().size() > 0) {
            this.getCamelContexts().get(0).stop();
        }
    }

    @Override
    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContexts().size() > 0) {
            return this.getCamelContexts().get(0).createProducerTemplate();
        }
        return null;
    }

    @Override
    protected Map<String, CamelContext> getCamelContextMap() {
        HashMap<String, CamelContext> answer = new HashMap<String, CamelContext>();
        CamelContext camelContext = this.createContext();
        if (this.registry.size() > 0 && DefaultCamelContext.class.isAssignableFrom(camelContext.getClass())) {
            CompositeRegistry compositeRegistry = new CompositeRegistry();
            compositeRegistry.addRegistry(this.registry);
            compositeRegistry.addRegistry(((DefaultCamelContext)camelContext).getRegistry());
            ((DefaultCamelContext)camelContext).setRegistry(compositeRegistry);
        }
        answer.put("camel-1", camelContext);
        return answer;
    }

    protected CamelContext createContext() {
        return new DefaultCamelContext();
    }
}

