/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified.data.node;

import java.io.Serializable;
import java.util.Date;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;

public class DataProperty {
    private DataNode.DataPropertyType type;
    private Object value;
    private String name;

    public DataProperty(String name, Object value, DataNode.DataPropertyType type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getString() {
        return this.value != null ? String.valueOf(this.value) : null;
    }

    public boolean getBoolean() {
        return this.value != null ? Boolean.valueOf(this.getString()) : null;
    }

    public long getLong() {
        return this.value != null ? Long.valueOf(this.getString()) : null;
    }

    public double getDouble() {
        return this.value != null ? Double.valueOf(this.getString()) : null;
    }

    public DataNodeRef getRef() {
        return this.value != null ? new DataNodeRef((Serializable)((Object)this.value.toString())) : null;
    }

    public Date getDate() {
        if (this.value == null) {
            return null;
        }
        if (!(this.value instanceof Date)) {
            throw new IllegalArgumentException();
        }
        return new Date(((Date)this.value).getTime());
    }

    public DataNode.DataPropertyType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataProperty other = (DataProperty)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "DataProperty [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + "]";
    }
}

