/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified.data.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;

public class DataNode {
    private String name;
    private Serializable id;
    private Map<String, DataNode> nodeNameToNodeMap = new HashMap<String, DataNode>();
    private List<DataNode> childNodes = new ArrayList<DataNode>();
    private Map<String, DataProperty> propNameToPropMap = new HashMap<String, DataProperty>();

    public DataNode(String name) {
        this.name = name;
    }

    public DataNode addNode(String name) {
        DataNode child = new DataNode(name);
        this.internalAddNode(child);
        return child;
    }

    public void addNode(DataNode child) {
        this.internalAddNode(child);
    }

    protected void internalAddNode(DataNode child) {
        this.childNodes.add(child);
        this.nodeNameToNodeMap.put(child.getName(), child);
    }

    public Iterable<DataNode> getNodes() {
        return this.childNodes;
    }

    public DataNode getNode(String name) {
        return this.nodeNameToNodeMap.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setProperty(String name, String value) {
        this.propNameToPropMap.put(name, new DataProperty(name, value, DataPropertyType.STRING));
    }

    public void setProperty(String name, boolean value) {
        this.propNameToPropMap.put(name, new DataProperty(name, value, DataPropertyType.BOOLEAN));
    }

    public void setProperty(String name, double value) {
        this.propNameToPropMap.put(name, new DataProperty(name, value, DataPropertyType.DOUBLE));
    }

    public void setProperty(String name, long value) {
        this.propNameToPropMap.put(name, new DataProperty(name, value, DataPropertyType.LONG));
    }

    public void setProperty(String name, Date value) {
        this.propNameToPropMap.put(name, new DataProperty(name, value, DataPropertyType.DATE));
    }

    public void setProperty(String name, DataNodeRef value) {
        this.propNameToPropMap.put(name, new DataProperty(name, value, DataPropertyType.REF));
    }

    public boolean hasProperty(String name) {
        return this.propNameToPropMap.containsKey(name);
    }

    public boolean hasNode(String name) {
        return this.nodeNameToNodeMap.containsKey(name);
    }

    public DataProperty getProperty(String name) {
        return this.propNameToPropMap.get(name);
    }

    public Iterable<DataProperty> getProperties() {
        return this.propNameToPropMap.values();
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public Serializable getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childNodes == null ? 0 : this.childNodes.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodeNameToNodeMap == null ? 0 : this.nodeNameToNodeMap.hashCode());
        result = 31 * result + (this.propNameToPropMap == null ? 0 : this.propNameToPropMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataNode other = (DataNode)obj;
        if (this.childNodes == null ? other.childNodes != null : !this.childNodes.equals(other.childNodes)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodeNameToNodeMap == null ? other.nodeNameToNodeMap != null : !this.nodeNameToNodeMap.equals(other.nodeNameToNodeMap)) {
            return false;
        }
        return !(this.propNameToPropMap == null ? other.propNameToPropMap != null : !this.propNameToPropMap.equals(other.propNameToPropMap));
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int depth) {
        String SPACER = "  ";
        String NL = "\n";
        String SLASH = "/";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
        buf.append(this.getName());
        buf.append("/ ");
        buf.append(this.propNameToPropMap);
        buf.append("\n");
        for (DataNode child : this.childNodes) {
            buf.append(child.toString(depth + 1));
        }
        return buf.toString();
    }

    public static enum DataPropertyType {
        BOOLEAN,
        DATE,
        DOUBLE,
        LONG,
        STRING,
        REF;

    }
}

