/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.reflect.MethodTimedOutException;
import com.infobright.reflect.TimeoutEnabledMethod;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;

class ClientProxy {
    private static final long DEFAULT_TIMEOUT = 5000L;
    private final String hostName;
    private final long timeout;
    private String osName;
    private final Socket socket;
    private final DataInputStream in;
    private final DataOutputStream out;

    String getHostName() {
        return this.hostName;
    }

    ClientProxy(String hostName, int port) throws IOException {
        this(hostName, port, 5000L);
    }

    ClientProxy(String hostName, int port, long timeout) throws IOException {
        this.hostName = hostName;
        this.timeout = timeout;
        this.socket = new Socket(hostName, port);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.osName = this.in.readUTF();
    }

    String getOSName() throws IOException {
        return this.osName;
    }

    void connect(String pipeName) throws IOException {
        try {
            Method connectIndefinite = this.getClass().getDeclaredMethod("connectIndefinite", String.class);
            connectIndefinite.setAccessible(true);
            TimeoutEnabledMethod connect = new TimeoutEnabledMethod(connectIndefinite);
            connect.invoke(this.timeout, this, pipeName);
        }
        catch (MethodTimedOutException e) {
            throw new IOException("connection to agent timed out after " + this.timeout + "ms");
        }
        catch (InvocationTargetException e) {
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void connectIndefinite(String pipeName) throws IOException {
        this.out.writeUTF(pipeName);
        this.out.flush();
        String response = this.in.readUTF();
        if (!"ok".equals(response)) {
            throw new IOException("Agent failed to create pipe on remote side");
        }
    }

    void write(byte[] data) throws IOException {
        this.out.write(data);
    }

    void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
    }

    void disconnect() throws IOException {
        this.out.close();
        this.socket.close();
    }
}

