/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;

class FloatType
extends AbstractColumnType {
    private Float data = new Float(0.0f);

    FloatType() {
    }

    public String getDataAsString() {
        return this.data.toString();
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.putFloat(this.data.floatValue());
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        this.data = Float.valueOf(byteBuffer.getFloat());
    }

    public void setData(String string) {
        this.data = Float.valueOf(string);
    }

    protected void zeroOutData() {
        this.data = Float.valueOf(0.0f);
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            Double val = meta.getNumber(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                this.data = Float.valueOf(val.floatValue());
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

